/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ecr.model.ImageIdentifier;
import software.amazon.awssdk.services.ecr.model.ImageIdentifierListCopier;
import software.amazon.awssdk.services.ecr.model.LifecyclePolicyPreviewFilter;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetLifecyclePolicyPreviewRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetLifecyclePolicyPreviewRequest> {
    private final String registryId;
    private final String repositoryName;
    private final List<ImageIdentifier> imageIds;
    private final String nextToken;
    private final Integer maxResults;
    private final LifecyclePolicyPreviewFilter filter;

    private GetLifecyclePolicyPreviewRequest(BuilderImpl builder) {
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.imageIds = builder.imageIds;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.filter = builder.filter;
    }

    public String registryId() {
        return this.registryId;
    }

    public String repositoryName() {
        return this.repositoryName;
    }

    public List<ImageIdentifier> imageIds() {
        return this.imageIds;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public LifecyclePolicyPreviewFilter filter() {
        return this.filter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.registryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.filter());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLifecyclePolicyPreviewRequest)) {
            return false;
        }
        GetLifecyclePolicyPreviewRequest other = (GetLifecyclePolicyPreviewRequest)((Object)obj);
        return Objects.equals(this.registryId(), other.registryId()) && Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.imageIds(), other.imageIds()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.filter(), other.filter());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.registryId() != null) {
            sb.append("RegistryId: ").append(this.registryId()).append(",");
        }
        if (this.repositoryName() != null) {
            sb.append("RepositoryName: ").append(this.repositoryName()).append(",");
        }
        if (this.imageIds() != null) {
            sb.append("ImageIds: ").append(this.imageIds()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        if (this.filter() != null) {
            sb.append("Filter: ").append(this.filter()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "registryId": {
                return Optional.of(clazz.cast(this.registryId()));
            }
            case "repositoryName": {
                return Optional.of(clazz.cast(this.repositoryName()));
            }
            case "imageIds": {
                return Optional.of(clazz.cast(this.imageIds()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
            case "filter": {
                return Optional.of(clazz.cast(this.filter()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String registryId;
        private String repositoryName;
        private List<ImageIdentifier> imageIds;
        private String nextToken;
        private Integer maxResults;
        private LifecyclePolicyPreviewFilter filter;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLifecyclePolicyPreviewRequest model) {
            this.registryId(model.registryId);
            this.repositoryName(model.repositoryName);
            this.imageIds(model.imageIds);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
            this.filter(model.filter);
        }

        public final String getRegistryId() {
            return this.registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final Collection<ImageIdentifier.Builder> getImageIds() {
            return this.imageIds != null ? (Collection)this.imageIds.stream().map(ImageIdentifier::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder imageIds(Collection<ImageIdentifier> imageIds) {
            this.imageIds = ImageIdentifierListCopier.copy(imageIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageIds(ImageIdentifier ... imageIds) {
            this.imageIds(Arrays.asList(imageIds));
            return this;
        }

        public final void setImageIds(Collection<ImageIdentifier.BuilderImpl> imageIds) {
            this.imageIds = ImageIdentifierListCopier.copyFromBuilder(imageIds);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final LifecyclePolicyPreviewFilter.Builder getFilter() {
            return this.filter != null ? this.filter.toBuilder() : null;
        }

        @Override
        public final Builder filter(LifecyclePolicyPreviewFilter filter) {
            this.filter = filter;
            return this;
        }

        public final void setFilter(LifecyclePolicyPreviewFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        public GetLifecyclePolicyPreviewRequest build() {
            return new GetLifecyclePolicyPreviewRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetLifecyclePolicyPreviewRequest> {
        public Builder registryId(String var1);

        public Builder repositoryName(String var1);

        public Builder imageIds(Collection<ImageIdentifier> var1);

        public Builder imageIds(ImageIdentifier ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder filter(LifecyclePolicyPreviewFilter var1);

        default public Builder filter(Consumer<LifecyclePolicyPreviewFilter.Builder> filter) {
            return this.filter((LifecyclePolicyPreviewFilter)((LifecyclePolicyPreviewFilter.Builder)LifecyclePolicyPreviewFilter.builder().apply(filter)).build());
        }
    }
}

