/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.ecr.model.Layer;
import software.amazon.awssdk.services.ecr.model.LayerFailure;
import software.amazon.awssdk.services.ecr.model.LayerFailureListCopier;
import software.amazon.awssdk.services.ecr.model.LayerListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchCheckLayerAvailabilityResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, BatchCheckLayerAvailabilityResponse> {
    private final List<Layer> layers;
    private final List<LayerFailure> failures;

    private BatchCheckLayerAvailabilityResponse(BuilderImpl builder) {
        this.layers = builder.layers;
        this.failures = builder.failures;
    }

    public List<Layer> layers() {
        return this.layers;
    }

    public List<LayerFailure> failures() {
        return this.failures;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.layers());
        hashCode = 31 * hashCode + Objects.hashCode(this.failures());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCheckLayerAvailabilityResponse)) {
            return false;
        }
        BatchCheckLayerAvailabilityResponse other = (BatchCheckLayerAvailabilityResponse)((Object)obj);
        return Objects.equals(this.layers(), other.layers()) && Objects.equals(this.failures(), other.failures());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.layers() != null) {
            sb.append("Layers: ").append(this.layers()).append(",");
        }
        if (this.failures() != null) {
            sb.append("Failures: ").append(this.failures()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "layers": {
                return Optional.of(clazz.cast(this.layers()));
            }
            case "failures": {
                return Optional.of(clazz.cast(this.failures()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<Layer> layers;
        private List<LayerFailure> failures;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchCheckLayerAvailabilityResponse model) {
            this.layers(model.layers);
            this.failures(model.failures);
        }

        public final Collection<Layer.Builder> getLayers() {
            return this.layers != null ? (Collection)this.layers.stream().map(Layer::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder layers(Collection<Layer> layers) {
            this.layers = LayerListCopier.copy(layers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layers(Layer ... layers) {
            this.layers(Arrays.asList(layers));
            return this;
        }

        public final void setLayers(Collection<Layer.BuilderImpl> layers) {
            this.layers = LayerListCopier.copyFromBuilder(layers);
        }

        public final Collection<LayerFailure.Builder> getFailures() {
            return this.failures != null ? (Collection)this.failures.stream().map(LayerFailure::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder failures(Collection<LayerFailure> failures) {
            this.failures = LayerFailureListCopier.copy(failures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(LayerFailure ... failures) {
            this.failures(Arrays.asList(failures));
            return this;
        }

        public final void setFailures(Collection<LayerFailure.BuilderImpl> failures) {
            this.failures = LayerFailureListCopier.copyFromBuilder(failures);
        }

        public BatchCheckLayerAvailabilityResponse build() {
            return new BatchCheckLayerAvailabilityResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchCheckLayerAvailabilityResponse> {
        public Builder layers(Collection<Layer> var1);

        public Builder layers(Layer ... var1);

        public Builder failures(Collection<LayerFailure> var1);

        public Builder failures(LayerFailure ... var1);
    }
}

