/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SetRepositoryPolicyRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, SetRepositoryPolicyRequest> {
    private final String registryId;
    private final String repositoryName;
    private final String policyText;
    private final Boolean force;

    private SetRepositoryPolicyRequest(BuilderImpl builder) {
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.policyText = builder.policyText;
        this.force = builder.force;
    }

    public String registryId() {
        return this.registryId;
    }

    public String repositoryName() {
        return this.repositoryName;
    }

    public String policyText() {
        return this.policyText;
    }

    public Boolean force() {
        return this.force;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.registryId() == null ? 0 : this.registryId().hashCode());
        hashCode = 31 * hashCode + (this.repositoryName() == null ? 0 : this.repositoryName().hashCode());
        hashCode = 31 * hashCode + (this.policyText() == null ? 0 : this.policyText().hashCode());
        hashCode = 31 * hashCode + (this.force() == null ? 0 : this.force().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetRepositoryPolicyRequest)) {
            return false;
        }
        SetRepositoryPolicyRequest other = (SetRepositoryPolicyRequest)((Object)obj);
        if (other.registryId() == null ^ this.registryId() == null) {
            return false;
        }
        if (other.registryId() != null && !other.registryId().equals(this.registryId())) {
            return false;
        }
        if (other.repositoryName() == null ^ this.repositoryName() == null) {
            return false;
        }
        if (other.repositoryName() != null && !other.repositoryName().equals(this.repositoryName())) {
            return false;
        }
        if (other.policyText() == null ^ this.policyText() == null) {
            return false;
        }
        if (other.policyText() != null && !other.policyText().equals(this.policyText())) {
            return false;
        }
        if (other.force() == null ^ this.force() == null) {
            return false;
        }
        return other.force() == null || other.force().equals(this.force());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.registryId() != null) {
            sb.append("RegistryId: ").append(this.registryId()).append(",");
        }
        if (this.repositoryName() != null) {
            sb.append("RepositoryName: ").append(this.repositoryName()).append(",");
        }
        if (this.policyText() != null) {
            sb.append("PolicyText: ").append(this.policyText()).append(",");
        }
        if (this.force() != null) {
            sb.append("Force: ").append(this.force()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "registryId": {
                return Optional.of(clazz.cast(this.registryId()));
            }
            case "repositoryName": {
                return Optional.of(clazz.cast(this.repositoryName()));
            }
            case "policyText": {
                return Optional.of(clazz.cast(this.policyText()));
            }
            case "force": {
                return Optional.of(clazz.cast(this.force()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String registryId;
        private String repositoryName;
        private String policyText;
        private Boolean force;

        private BuilderImpl() {
        }

        private BuilderImpl(SetRepositoryPolicyRequest model) {
            this.registryId(model.registryId);
            this.repositoryName(model.repositoryName);
            this.policyText(model.policyText);
            this.force(model.force);
        }

        public final String getRegistryId() {
            return this.registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final String getPolicyText() {
            return this.policyText;
        }

        @Override
        public final Builder policyText(String policyText) {
            this.policyText = policyText;
            return this;
        }

        public final void setPolicyText(String policyText) {
            this.policyText = policyText;
        }

        public final Boolean getForce() {
            return this.force;
        }

        @Override
        public final Builder force(Boolean force) {
            this.force = force;
            return this;
        }

        public final void setForce(Boolean force) {
            this.force = force;
        }

        public SetRepositoryPolicyRequest build() {
            return new SetRepositoryPolicyRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SetRepositoryPolicyRequest> {
        public Builder registryId(String var1);

        public Builder repositoryName(String var1);

        public Builder policyText(String var1);

        public Builder force(Boolean var1);
    }
}

