/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.ecr.model.AuthorizationData;
import software.amazon.awssdk.services.ecr.model.AuthorizationDataListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetAuthorizationTokenResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetAuthorizationTokenResponse> {
    private final List<AuthorizationData> authorizationData;

    private GetAuthorizationTokenResponse(BuilderImpl builder) {
        this.authorizationData = builder.authorizationData;
    }

    public List<AuthorizationData> authorizationData() {
        return this.authorizationData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.authorizationData() == null ? 0 : this.authorizationData().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAuthorizationTokenResponse)) {
            return false;
        }
        GetAuthorizationTokenResponse other = (GetAuthorizationTokenResponse)((Object)obj);
        if (other.authorizationData() == null ^ this.authorizationData() == null) {
            return false;
        }
        return other.authorizationData() == null || other.authorizationData().equals(this.authorizationData());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.authorizationData() != null) {
            sb.append("AuthorizationData: ").append(this.authorizationData()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "authorizationData": {
                return Optional.of(clazz.cast(this.authorizationData()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<AuthorizationData> authorizationData;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAuthorizationTokenResponse model) {
            this.authorizationData(model.authorizationData);
        }

        public final Collection<AuthorizationData.Builder> getAuthorizationData() {
            return this.authorizationData != null ? (Collection)this.authorizationData.stream().map(AuthorizationData::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder authorizationData(Collection<AuthorizationData> authorizationData) {
            this.authorizationData = AuthorizationDataListCopier.copy(authorizationData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizationData(AuthorizationData ... authorizationData) {
            this.authorizationData(Arrays.asList(authorizationData));
            return this;
        }

        public final void setAuthorizationData(Collection<AuthorizationData.BuilderImpl> authorizationData) {
            this.authorizationData = AuthorizationDataListCopier.copyFromBuilder(authorizationData);
        }

        public GetAuthorizationTokenResponse build() {
            return new GetAuthorizationTokenResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetAuthorizationTokenResponse> {
        public Builder authorizationData(Collection<AuthorizationData> var1);

        public Builder authorizationData(AuthorizationData ... var1);
    }
}

