/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import software.amazon.awssdk.services.ecr.model.ECRException;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class InvalidLayerPartException
extends ECRException
implements ToCopyableBuilder<Builder, InvalidLayerPartException> {
    private final String registryId;
    private final String repositoryName;
    private final String uploadId;
    private final Long lastValidByteReceived;

    private InvalidLayerPartException(BuilderImpl builder) {
        super(builder.message);
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.uploadId = builder.uploadId;
        this.lastValidByteReceived = builder.lastValidByteReceived;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public String registryId() {
        return this.registryId;
    }

    public String repositoryName() {
        return this.repositoryName;
    }

    public String uploadId() {
        return this.uploadId;
    }

    public Long lastValidByteReceived() {
        return this.lastValidByteReceived;
    }

    private static final class BuilderImpl
    implements Builder {
        private String registryId;
        private String repositoryName;
        private String uploadId;
        private Long lastValidByteReceived;
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(InvalidLayerPartException model) {
            this.setRegistryId(model.registryId);
            this.setRepositoryName(model.repositoryName);
            this.setUploadId(model.uploadId);
            this.setLastValidByteReceived(model.lastValidByteReceived);
            this.message = model.getMessage();
        }

        public final String getRegistryId() {
            return this.registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        @JsonProperty(value="registryId")
        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        @JsonProperty(value="repositoryName")
        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final String getUploadId() {
            return this.uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        @JsonProperty(value="uploadId")
        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        public final Long getLastValidByteReceived() {
            return this.lastValidByteReceived;
        }

        @Override
        public final Builder lastValidByteReceived(Long lastValidByteReceived) {
            this.lastValidByteReceived = lastValidByteReceived;
            return this;
        }

        @JsonProperty(value="lastValidByteReceived")
        public final void setLastValidByteReceived(Long lastValidByteReceived) {
            this.lastValidByteReceived = lastValidByteReceived;
        }

        public String getMessage() {
            return this.message;
        }

        public String message() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        @Override
        public Builder message(String message) {
            this.message = message;
            return this;
        }

        public InvalidLayerPartException build() {
            return new InvalidLayerPartException(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InvalidLayerPartException> {
        public Builder registryId(String var1);

        public Builder repositoryName(String var1);

        public Builder uploadId(String var1);

        public Builder lastValidByteReceived(Long var1);

        public Builder message(String var1);
    }
}

