/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ecr.model.LayerDigestListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CompleteLayerUploadRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CompleteLayerUploadRequest> {
    private final String registryId;
    private final String repositoryName;
    private final String uploadId;
    private final List<String> layerDigests;

    private CompleteLayerUploadRequest(BuilderImpl builder) {
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.uploadId = builder.uploadId;
        this.layerDigests = builder.layerDigests;
    }

    public String registryId() {
        return this.registryId;
    }

    public String repositoryName() {
        return this.repositoryName;
    }

    public String uploadId() {
        return this.uploadId;
    }

    public List<String> layerDigests() {
        return this.layerDigests;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.registryId() == null ? 0 : this.registryId().hashCode());
        hashCode = 31 * hashCode + (this.repositoryName() == null ? 0 : this.repositoryName().hashCode());
        hashCode = 31 * hashCode + (this.uploadId() == null ? 0 : this.uploadId().hashCode());
        hashCode = 31 * hashCode + (this.layerDigests() == null ? 0 : this.layerDigests().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompleteLayerUploadRequest)) {
            return false;
        }
        CompleteLayerUploadRequest other = (CompleteLayerUploadRequest)((Object)obj);
        if (other.registryId() == null ^ this.registryId() == null) {
            return false;
        }
        if (other.registryId() != null && !other.registryId().equals(this.registryId())) {
            return false;
        }
        if (other.repositoryName() == null ^ this.repositoryName() == null) {
            return false;
        }
        if (other.repositoryName() != null && !other.repositoryName().equals(this.repositoryName())) {
            return false;
        }
        if (other.uploadId() == null ^ this.uploadId() == null) {
            return false;
        }
        if (other.uploadId() != null && !other.uploadId().equals(this.uploadId())) {
            return false;
        }
        if (other.layerDigests() == null ^ this.layerDigests() == null) {
            return false;
        }
        return other.layerDigests() == null || other.layerDigests().equals(this.layerDigests());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.registryId() != null) {
            sb.append("RegistryId: ").append(this.registryId()).append(",");
        }
        if (this.repositoryName() != null) {
            sb.append("RepositoryName: ").append(this.repositoryName()).append(",");
        }
        if (this.uploadId() != null) {
            sb.append("UploadId: ").append(this.uploadId()).append(",");
        }
        if (this.layerDigests() != null) {
            sb.append("LayerDigests: ").append(this.layerDigests()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String registryId;
        private String repositoryName;
        private String uploadId;
        private List<String> layerDigests;

        private BuilderImpl() {
        }

        private BuilderImpl(CompleteLayerUploadRequest model) {
            this.setRegistryId(model.registryId);
            this.setRepositoryName(model.repositoryName);
            this.setUploadId(model.uploadId);
            this.setLayerDigests(model.layerDigests);
        }

        public final String getRegistryId() {
            return this.registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final String getUploadId() {
            return this.uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        public final Collection<String> getLayerDigests() {
            return this.layerDigests;
        }

        @Override
        public final Builder layerDigests(Collection<String> layerDigests) {
            this.layerDigests = LayerDigestListCopier.copy(layerDigests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layerDigests(String ... layerDigests) {
            this.layerDigests(Arrays.asList(layerDigests));
            return this;
        }

        public final void setLayerDigests(Collection<String> layerDigests) {
            this.layerDigests = LayerDigestListCopier.copy(layerDigests);
        }

        public CompleteLayerUploadRequest build() {
            return new CompleteLayerUploadRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CompleteLayerUploadRequest> {
        public Builder registryId(String var1);

        public Builder repositoryName(String var1);

        public Builder uploadId(String var1);

        public Builder layerDigests(Collection<String> var1);

        public Builder layerDigests(String ... var1);
    }
}

