/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ecr.model.Layer;

@SdkInternalApi
public class LayerMarshaller {
    private static final MarshallingInfo<String> LAYERDIGEST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("layerDigest").build();
    private static final MarshallingInfo<String> LAYERAVAILABILITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("layerAvailability").build();
    private static final MarshallingInfo<Long> LAYERSIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("layerSize").build();
    private static final MarshallingInfo<String> MEDIATYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("mediaType").build();
    private static final LayerMarshaller instance = new LayerMarshaller();

    public static LayerMarshaller getInstance() {
        return instance;
    }

    public void marshall(Layer layer, ProtocolMarshaller protocolMarshaller) {
        if (layer == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)layer.layerDigest(), LAYERDIGEST_BINDING);
            protocolMarshaller.marshall((Object)layer.layerAvailability(), LAYERAVAILABILITY_BINDING);
            protocolMarshaller.marshall((Object)layer.layerSize(), LAYERSIZE_BINDING);
            protocolMarshaller.marshall((Object)layer.mediaType(), MEDIATYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

