/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.ecr.model.ImageTagListCopier;
import software.amazon.awssdk.services.ecr.transform.ImageDetailMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ImageDetail
implements StructuredPojo,
ToCopyableBuilder<Builder, ImageDetail> {
    private final String registryId;
    private final String repositoryName;
    private final String imageDigest;
    private final List<String> imageTags;
    private final Long imageSizeInBytes;
    private final Instant imagePushedAt;

    private ImageDetail(BuilderImpl builder) {
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.imageDigest = builder.imageDigest;
        this.imageTags = builder.imageTags;
        this.imageSizeInBytes = builder.imageSizeInBytes;
        this.imagePushedAt = builder.imagePushedAt;
    }

    public String registryId() {
        return this.registryId;
    }

    public String repositoryName() {
        return this.repositoryName;
    }

    public String imageDigest() {
        return this.imageDigest;
    }

    public List<String> imageTags() {
        return this.imageTags;
    }

    public Long imageSizeInBytes() {
        return this.imageSizeInBytes;
    }

    public Instant imagePushedAt() {
        return this.imagePushedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.registryId() == null ? 0 : this.registryId().hashCode());
        hashCode = 31 * hashCode + (this.repositoryName() == null ? 0 : this.repositoryName().hashCode());
        hashCode = 31 * hashCode + (this.imageDigest() == null ? 0 : this.imageDigest().hashCode());
        hashCode = 31 * hashCode + (this.imageTags() == null ? 0 : this.imageTags().hashCode());
        hashCode = 31 * hashCode + (this.imageSizeInBytes() == null ? 0 : this.imageSizeInBytes().hashCode());
        hashCode = 31 * hashCode + (this.imagePushedAt() == null ? 0 : this.imagePushedAt().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageDetail)) {
            return false;
        }
        ImageDetail other = (ImageDetail)obj;
        if (other.registryId() == null ^ this.registryId() == null) {
            return false;
        }
        if (other.registryId() != null && !other.registryId().equals(this.registryId())) {
            return false;
        }
        if (other.repositoryName() == null ^ this.repositoryName() == null) {
            return false;
        }
        if (other.repositoryName() != null && !other.repositoryName().equals(this.repositoryName())) {
            return false;
        }
        if (other.imageDigest() == null ^ this.imageDigest() == null) {
            return false;
        }
        if (other.imageDigest() != null && !other.imageDigest().equals(this.imageDigest())) {
            return false;
        }
        if (other.imageTags() == null ^ this.imageTags() == null) {
            return false;
        }
        if (other.imageTags() != null && !other.imageTags().equals(this.imageTags())) {
            return false;
        }
        if (other.imageSizeInBytes() == null ^ this.imageSizeInBytes() == null) {
            return false;
        }
        if (other.imageSizeInBytes() != null && !other.imageSizeInBytes().equals(this.imageSizeInBytes())) {
            return false;
        }
        if (other.imagePushedAt() == null ^ this.imagePushedAt() == null) {
            return false;
        }
        return other.imagePushedAt() == null || other.imagePushedAt().equals(this.imagePushedAt());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.registryId() != null) {
            sb.append("RegistryId: ").append(this.registryId()).append(",");
        }
        if (this.repositoryName() != null) {
            sb.append("RepositoryName: ").append(this.repositoryName()).append(",");
        }
        if (this.imageDigest() != null) {
            sb.append("ImageDigest: ").append(this.imageDigest()).append(",");
        }
        if (this.imageTags() != null) {
            sb.append("ImageTags: ").append(this.imageTags()).append(",");
        }
        if (this.imageSizeInBytes() != null) {
            sb.append("ImageSizeInBytes: ").append(this.imageSizeInBytes()).append(",");
        }
        if (this.imagePushedAt() != null) {
            sb.append("ImagePushedAt: ").append(this.imagePushedAt()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ImageDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String registryId;
        private String repositoryName;
        private String imageDigest;
        private List<String> imageTags;
        private Long imageSizeInBytes;
        private Instant imagePushedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageDetail model) {
            this.setRegistryId(model.registryId);
            this.setRepositoryName(model.repositoryName);
            this.setImageDigest(model.imageDigest);
            this.setImageTags(model.imageTags);
            this.setImageSizeInBytes(model.imageSizeInBytes);
            this.setImagePushedAt(model.imagePushedAt);
        }

        public final String getRegistryId() {
            return this.registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final String getImageDigest() {
            return this.imageDigest;
        }

        @Override
        public final Builder imageDigest(String imageDigest) {
            this.imageDigest = imageDigest;
            return this;
        }

        public final void setImageDigest(String imageDigest) {
            this.imageDigest = imageDigest;
        }

        public final Collection<String> getImageTags() {
            return this.imageTags;
        }

        @Override
        public final Builder imageTags(Collection<String> imageTags) {
            this.imageTags = ImageTagListCopier.copy(imageTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageTags(String ... imageTags) {
            this.imageTags(Arrays.asList(imageTags));
            return this;
        }

        public final void setImageTags(Collection<String> imageTags) {
            this.imageTags = ImageTagListCopier.copy(imageTags);
        }

        @SafeVarargs
        public final void setImageTags(String ... imageTags) {
            this.imageTags(Arrays.asList(imageTags));
        }

        public final Long getImageSizeInBytes() {
            return this.imageSizeInBytes;
        }

        @Override
        public final Builder imageSizeInBytes(Long imageSizeInBytes) {
            this.imageSizeInBytes = imageSizeInBytes;
            return this;
        }

        public final void setImageSizeInBytes(Long imageSizeInBytes) {
            this.imageSizeInBytes = imageSizeInBytes;
        }

        public final Instant getImagePushedAt() {
            return this.imagePushedAt;
        }

        @Override
        public final Builder imagePushedAt(Instant imagePushedAt) {
            this.imagePushedAt = imagePushedAt;
            return this;
        }

        public final void setImagePushedAt(Instant imagePushedAt) {
            this.imagePushedAt = imagePushedAt;
        }

        public ImageDetail build() {
            return new ImageDetail(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ImageDetail> {
        public Builder registryId(String var1);

        public Builder repositoryName(String var1);

        public Builder imageDigest(String var1);

        public Builder imageTags(Collection<String> var1);

        public Builder imageTags(String ... var1);

        public Builder imageSizeInBytes(Long var1);

        public Builder imagePushedAt(Instant var1);
    }
}

