/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.services.ecr.model.EcrException;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InvalidLayerPartException
extends EcrException
implements ToCopyableBuilder<Builder, InvalidLayerPartException> {
    private final String registryId;
    private final String repositoryName;
    private final String uploadId;
    private final Long lastValidByteReceived;

    private InvalidLayerPartException(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.uploadId = builder.uploadId;
        this.lastValidByteReceived = builder.lastValidByteReceived;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public String registryId() {
        return this.registryId;
    }

    public String repositoryName() {
        return this.repositoryName;
    }

    public String uploadId() {
        return this.uploadId;
    }

    public Long lastValidByteReceived() {
        return this.lastValidByteReceived;
    }

    static final class BuilderImpl
    extends EcrException.BuilderImpl
    implements Builder {
        private String registryId;
        private String repositoryName;
        private String uploadId;
        private Long lastValidByteReceived;

        private BuilderImpl() {
        }

        private BuilderImpl(InvalidLayerPartException model) {
            super(model);
            this.registryId(model.registryId);
            this.repositoryName(model.repositoryName);
            this.uploadId(model.uploadId);
            this.lastValidByteReceived(model.lastValidByteReceived);
        }

        public final String getRegistryId() {
            return this.registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        @JsonProperty(value="registryId")
        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        @JsonProperty(value="repositoryName")
        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final String getUploadId() {
            return this.uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        @JsonProperty(value="uploadId")
        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        public final Long getLastValidByteReceived() {
            return this.lastValidByteReceived;
        }

        @Override
        public final Builder lastValidByteReceived(Long lastValidByteReceived) {
            this.lastValidByteReceived = lastValidByteReceived;
            return this;
        }

        @JsonProperty(value="lastValidByteReceived")
        public final void setLastValidByteReceived(Long lastValidByteReceived) {
            this.lastValidByteReceived = lastValidByteReceived;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public InvalidLayerPartException build() {
            return new InvalidLayerPartException(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, InvalidLayerPartException>,
    EcrException.Builder {
        public Builder registryId(String var1);

        public Builder repositoryName(String var1);

        public Builder uploadId(String var1);

        public Builder lastValidByteReceived(Long var1);

        @Override
        public Builder awsErrorDetails(AwsErrorDetails var1);

        @Override
        public Builder message(String var1);

        @Override
        public Builder requestId(String var1);

        @Override
        public Builder statusCode(int var1);

        @Override
        public Builder cause(Throwable var1);
    }
}

