/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ecr.model.LifecyclePolicyPreviewResult;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class LifecyclePolicyPreviewResultMarshaller {
    private static final MarshallingInfo<List> IMAGETAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("imageTags").isBinary(false).build();
    private static final MarshallingInfo<String> IMAGEDIGEST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("imageDigest").isBinary(false).build();
    private static final MarshallingInfo<Instant> IMAGEPUSHEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("imagePushedAt").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("action").isBinary(false).build();
    private static final MarshallingInfo<Integer> APPLIEDRULEPRIORITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("appliedRulePriority").isBinary(false).build();
    private static final LifecyclePolicyPreviewResultMarshaller INSTANCE = new LifecyclePolicyPreviewResultMarshaller();

    private LifecyclePolicyPreviewResultMarshaller() {
    }

    public static LifecyclePolicyPreviewResultMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(LifecyclePolicyPreviewResult lifecyclePolicyPreviewResult, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)lifecyclePolicyPreviewResult, (String)"lifecyclePolicyPreviewResult");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(lifecyclePolicyPreviewResult.imageTags(), IMAGETAGS_BINDING);
            protocolMarshaller.marshall((Object)lifecyclePolicyPreviewResult.imageDigest(), IMAGEDIGEST_BINDING);
            protocolMarshaller.marshall((Object)lifecyclePolicyPreviewResult.imagePushedAt(), IMAGEPUSHEDAT_BINDING);
            protocolMarshaller.marshall((Object)lifecyclePolicyPreviewResult.action(), ACTION_BINDING);
            protocolMarshaller.marshall((Object)lifecyclePolicyPreviewResult.appliedRulePriority(), APPLIEDRULEPRIORITY_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

