/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ecr.model.Image;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ImageMarshaller {
    private static final MarshallingInfo<String> REGISTRYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("registryId").isBinary(false).build();
    private static final MarshallingInfo<String> REPOSITORYNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("repositoryName").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> IMAGEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("imageId").isBinary(false).build();
    private static final MarshallingInfo<String> IMAGEMANIFEST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("imageManifest").isBinary(false).build();
    private static final ImageMarshaller INSTANCE = new ImageMarshaller();

    private ImageMarshaller() {
    }

    public static ImageMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(Image image, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)image, (String)"image");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)image.registryId(), REGISTRYID_BINDING);
            protocolMarshaller.marshall((Object)image.repositoryName(), REPOSITORYNAME_BINDING);
            protocolMarshaller.marshall((Object)image.imageId(), IMAGEID_BINDING);
            protocolMarshaller.marshall((Object)image.imageManifest(), IMAGEMANIFEST_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

