/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.ecr.ECRClient;
import software.amazon.awssdk.services.ecr.model.ImageIdentifier;
import software.amazon.awssdk.services.ecr.model.ListImagesRequest;
import software.amazon.awssdk.services.ecr.model.ListImagesResponse;

public class ListImagesIterable
implements SdkIterable<ListImagesResponse> {
    private final ECRClient client;
    private final ListImagesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListImagesIterable(ECRClient client, ListImagesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListImagesResponseFetcher();
    }

    public Iterator<ListImagesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<ImageIdentifier> imageIds() {
        Function<ListImagesResponse, Iterator> getIterator = response -> {
            if (response != null && response.imageIds() != null) {
                return response.imageIds().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final ListImagesIterable resume(ListImagesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListImagesIterable(this.client, (ListImagesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListImagesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListImagesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListImagesResponseFetcher
    implements SyncPageFetcher<ListImagesResponse> {
        private ListImagesResponseFetcher() {
        }

        public boolean hasNextPage(ListImagesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListImagesResponse nextPage(ListImagesResponse previousPage) {
            if (previousPage == null) {
                return ListImagesIterable.this.client.listImages(ListImagesIterable.this.firstRequest);
            }
            return ListImagesIterable.this.client.listImages((ListImagesRequest)((Object)ListImagesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

