/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ecr.model.ImageTagListCopier;
import software.amazon.awssdk.services.ecr.transform.ImageDetailMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ImageDetail
implements StructuredPojo,
ToCopyableBuilder<Builder, ImageDetail> {
    private final String registryId;
    private final String repositoryName;
    private final String imageDigest;
    private final List<String> imageTags;
    private final Long imageSizeInBytes;
    private final Instant imagePushedAt;

    private ImageDetail(BuilderImpl builder) {
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.imageDigest = builder.imageDigest;
        this.imageTags = builder.imageTags;
        this.imageSizeInBytes = builder.imageSizeInBytes;
        this.imagePushedAt = builder.imagePushedAt;
    }

    public String registryId() {
        return this.registryId;
    }

    public String repositoryName() {
        return this.repositoryName;
    }

    public String imageDigest() {
        return this.imageDigest;
    }

    public List<String> imageTags() {
        return this.imageTags;
    }

    public Long imageSizeInBytes() {
        return this.imageSizeInBytes;
    }

    public Instant imagePushedAt() {
        return this.imagePushedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.registryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageDigest());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageTags());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.imagePushedAt());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageDetail)) {
            return false;
        }
        ImageDetail other = (ImageDetail)obj;
        return Objects.equals(this.registryId(), other.registryId()) && Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.imageDigest(), other.imageDigest()) && Objects.equals(this.imageTags(), other.imageTags()) && Objects.equals(this.imageSizeInBytes(), other.imageSizeInBytes()) && Objects.equals(this.imagePushedAt(), other.imagePushedAt());
    }

    public String toString() {
        return ToString.builder((String)"ImageDetail").add("RegistryId", (Object)this.registryId()).add("RepositoryName", (Object)this.repositoryName()).add("ImageDigest", (Object)this.imageDigest()).add("ImageTags", this.imageTags()).add("ImageSizeInBytes", (Object)this.imageSizeInBytes()).add("ImagePushedAt", (Object)this.imagePushedAt()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "registryId": {
                return Optional.of(clazz.cast(this.registryId()));
            }
            case "repositoryName": {
                return Optional.of(clazz.cast(this.repositoryName()));
            }
            case "imageDigest": {
                return Optional.of(clazz.cast(this.imageDigest()));
            }
            case "imageTags": {
                return Optional.of(clazz.cast(this.imageTags()));
            }
            case "imageSizeInBytes": {
                return Optional.of(clazz.cast(this.imageSizeInBytes()));
            }
            case "imagePushedAt": {
                return Optional.of(clazz.cast(this.imagePushedAt()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ImageDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String registryId;
        private String repositoryName;
        private String imageDigest;
        private List<String> imageTags;
        private Long imageSizeInBytes;
        private Instant imagePushedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageDetail model) {
            this.registryId(model.registryId);
            this.repositoryName(model.repositoryName);
            this.imageDigest(model.imageDigest);
            this.imageTags(model.imageTags);
            this.imageSizeInBytes(model.imageSizeInBytes);
            this.imagePushedAt(model.imagePushedAt);
        }

        public final String getRegistryId() {
            return this.registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final String getImageDigest() {
            return this.imageDigest;
        }

        @Override
        public final Builder imageDigest(String imageDigest) {
            this.imageDigest = imageDigest;
            return this;
        }

        public final void setImageDigest(String imageDigest) {
            this.imageDigest = imageDigest;
        }

        public final Collection<String> getImageTags() {
            return this.imageTags;
        }

        @Override
        public final Builder imageTags(Collection<String> imageTags) {
            this.imageTags = ImageTagListCopier.copy(imageTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageTags(String ... imageTags) {
            this.imageTags(Arrays.asList(imageTags));
            return this;
        }

        public final void setImageTags(Collection<String> imageTags) {
            this.imageTags = ImageTagListCopier.copy(imageTags);
        }

        public final Long getImageSizeInBytes() {
            return this.imageSizeInBytes;
        }

        @Override
        public final Builder imageSizeInBytes(Long imageSizeInBytes) {
            this.imageSizeInBytes = imageSizeInBytes;
            return this;
        }

        public final void setImageSizeInBytes(Long imageSizeInBytes) {
            this.imageSizeInBytes = imageSizeInBytes;
        }

        public final Instant getImagePushedAt() {
            return this.imagePushedAt;
        }

        @Override
        public final Builder imagePushedAt(Instant imagePushedAt) {
            this.imagePushedAt = imagePushedAt;
            return this;
        }

        public final void setImagePushedAt(Instant imagePushedAt) {
            this.imagePushedAt = imagePushedAt;
        }

        public ImageDetail build() {
            return new ImageDetail(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ImageDetail> {
        public Builder registryId(String var1);

        public Builder repositoryName(String var1);

        public Builder imageDigest(String var1);

        public Builder imageTags(Collection<String> var1);

        public Builder imageTags(String ... var1);

        public Builder imageSizeInBytes(Long var1);

        public Builder imagePushedAt(Instant var1);
    }
}

