/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ecr.model.ECRResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetDownloadUrlForLayerResponse
extends ECRResponse
implements ToCopyableBuilder<Builder, GetDownloadUrlForLayerResponse> {
    private final String downloadUrl;
    private final String layerDigest;

    private GetDownloadUrlForLayerResponse(BuilderImpl builder) {
        super(builder);
        this.downloadUrl = builder.downloadUrl;
        this.layerDigest = builder.layerDigest;
    }

    public String downloadUrl() {
        return this.downloadUrl;
    }

    public String layerDigest() {
        return this.layerDigest;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.downloadUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.layerDigest());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDownloadUrlForLayerResponse)) {
            return false;
        }
        GetDownloadUrlForLayerResponse other = (GetDownloadUrlForLayerResponse)((Object)obj);
        return Objects.equals(this.downloadUrl(), other.downloadUrl()) && Objects.equals(this.layerDigest(), other.layerDigest());
    }

    public String toString() {
        return ToString.builder((String)"GetDownloadUrlForLayerResponse").add("DownloadUrl", (Object)this.downloadUrl()).add("LayerDigest", (Object)this.layerDigest()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "downloadUrl": {
                return Optional.of(clazz.cast(this.downloadUrl()));
            }
            case "layerDigest": {
                return Optional.of(clazz.cast(this.layerDigest()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ECRResponse.BuilderImpl
    implements Builder {
        private String downloadUrl;
        private String layerDigest;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDownloadUrlForLayerResponse model) {
            super(model);
            this.downloadUrl(model.downloadUrl);
            this.layerDigest(model.layerDigest);
        }

        public final String getDownloadUrl() {
            return this.downloadUrl;
        }

        @Override
        public final Builder downloadUrl(String downloadUrl) {
            this.downloadUrl = downloadUrl;
            return this;
        }

        public final void setDownloadUrl(String downloadUrl) {
            this.downloadUrl = downloadUrl;
        }

        public final String getLayerDigest() {
            return this.layerDigest;
        }

        @Override
        public final Builder layerDigest(String layerDigest) {
            this.layerDigest = layerDigest;
            return this;
        }

        public final void setLayerDigest(String layerDigest) {
            this.layerDigest = layerDigest;
        }

        @Override
        public GetDownloadUrlForLayerResponse build() {
            return new GetDownloadUrlForLayerResponse(this);
        }
    }

    public static interface Builder
    extends ECRResponse.Builder,
    CopyableBuilder<Builder, GetDownloadUrlForLayerResponse> {
        public Builder downloadUrl(String var1);

        public Builder layerDigest(String var1);
    }
}

