/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.ecr.model.ECRResponse;
import software.amazon.awssdk.services.ecr.model.Repository;
import software.amazon.awssdk.services.ecr.model.RepositoryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeRepositoriesResponse
extends ECRResponse
implements ToCopyableBuilder<Builder, DescribeRepositoriesResponse> {
    private final List<Repository> repositories;
    private final String nextToken;

    private DescribeRepositoriesResponse(BuilderImpl builder) {
        super(builder);
        this.repositories = builder.repositories;
        this.nextToken = builder.nextToken;
    }

    public List<Repository> repositories() {
        return this.repositories;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.repositories());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRepositoriesResponse)) {
            return false;
        }
        DescribeRepositoriesResponse other = (DescribeRepositoriesResponse)((Object)obj);
        return Objects.equals(this.repositories(), other.repositories()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeRepositoriesResponse").add("Repositories", this.repositories()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "repositories": {
                return Optional.of(clazz.cast(this.repositories()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ECRResponse.BuilderImpl
    implements Builder {
        private List<Repository> repositories;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRepositoriesResponse model) {
            super(model);
            this.repositories(model.repositories);
            this.nextToken(model.nextToken);
        }

        public final Collection<Repository.Builder> getRepositories() {
            return this.repositories != null ? (Collection)this.repositories.stream().map(Repository::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder repositories(Collection<Repository> repositories) {
            this.repositories = RepositoryListCopier.copy(repositories);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositories(Repository ... repositories) {
            this.repositories(Arrays.asList(repositories));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositories(Consumer<Repository.Builder> ... repositories) {
            this.repositories(Stream.of(repositories).map(c -> (Repository)((Repository.Builder)Repository.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRepositories(Collection<Repository.BuilderImpl> repositories) {
            this.repositories = RepositoryListCopier.copyFromBuilder(repositories);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeRepositoriesResponse build() {
            return new DescribeRepositoriesResponse(this);
        }
    }

    public static interface Builder
    extends ECRResponse.Builder,
    CopyableBuilder<Builder, DescribeRepositoriesResponse> {
        public Builder repositories(Collection<Repository> var1);

        public Builder repositories(Repository ... var1);

        public Builder repositories(Consumer<Repository.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

