/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.ecr.model.ECRResponse;
import software.amazon.awssdk.services.ecr.model.ImageFailure;
import software.amazon.awssdk.services.ecr.model.ImageFailureListCopier;
import software.amazon.awssdk.services.ecr.model.ImageIdentifier;
import software.amazon.awssdk.services.ecr.model.ImageIdentifierListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchDeleteImageResponse
extends ECRResponse
implements ToCopyableBuilder<Builder, BatchDeleteImageResponse> {
    private final List<ImageIdentifier> imageIds;
    private final List<ImageFailure> failures;

    private BatchDeleteImageResponse(BuilderImpl builder) {
        super(builder);
        this.imageIds = builder.imageIds;
        this.failures = builder.failures;
    }

    public List<ImageIdentifier> imageIds() {
        return this.imageIds;
    }

    public List<ImageFailure> failures() {
        return this.failures;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.imageIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.failures());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteImageResponse)) {
            return false;
        }
        BatchDeleteImageResponse other = (BatchDeleteImageResponse)((Object)obj);
        return Objects.equals(this.imageIds(), other.imageIds()) && Objects.equals(this.failures(), other.failures());
    }

    public String toString() {
        return ToString.builder((String)"BatchDeleteImageResponse").add("ImageIds", this.imageIds()).add("Failures", this.failures()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "imageIds": {
                return Optional.of(clazz.cast(this.imageIds()));
            }
            case "failures": {
                return Optional.of(clazz.cast(this.failures()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ECRResponse.BuilderImpl
    implements Builder {
        private List<ImageIdentifier> imageIds;
        private List<ImageFailure> failures;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteImageResponse model) {
            super(model);
            this.imageIds(model.imageIds);
            this.failures(model.failures);
        }

        public final Collection<ImageIdentifier.Builder> getImageIds() {
            return this.imageIds != null ? (Collection)this.imageIds.stream().map(ImageIdentifier::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder imageIds(Collection<ImageIdentifier> imageIds) {
            this.imageIds = ImageIdentifierListCopier.copy(imageIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageIds(ImageIdentifier ... imageIds) {
            this.imageIds(Arrays.asList(imageIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageIds(Consumer<ImageIdentifier.Builder> ... imageIds) {
            this.imageIds(Stream.of(imageIds).map(c -> (ImageIdentifier)((ImageIdentifier.Builder)ImageIdentifier.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setImageIds(Collection<ImageIdentifier.BuilderImpl> imageIds) {
            this.imageIds = ImageIdentifierListCopier.copyFromBuilder(imageIds);
        }

        public final Collection<ImageFailure.Builder> getFailures() {
            return this.failures != null ? (Collection)this.failures.stream().map(ImageFailure::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder failures(Collection<ImageFailure> failures) {
            this.failures = ImageFailureListCopier.copy(failures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(ImageFailure ... failures) {
            this.failures(Arrays.asList(failures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(Consumer<ImageFailure.Builder> ... failures) {
            this.failures(Stream.of(failures).map(c -> (ImageFailure)((ImageFailure.Builder)ImageFailure.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFailures(Collection<ImageFailure.BuilderImpl> failures) {
            this.failures = ImageFailureListCopier.copyFromBuilder(failures);
        }

        @Override
        public BatchDeleteImageResponse build() {
            return new BatchDeleteImageResponse(this);
        }
    }

    public static interface Builder
    extends ECRResponse.Builder,
    CopyableBuilder<Builder, BatchDeleteImageResponse> {
        public Builder imageIds(Collection<ImageIdentifier> var1);

        public Builder imageIds(ImageIdentifier ... var1);

        public Builder imageIds(Consumer<ImageIdentifier.Builder> ... var1);

        public Builder failures(Collection<ImageFailure> var1);

        public Builder failures(ImageFailure ... var1);

        public Builder failures(Consumer<ImageFailure.Builder> ... var1);
    }
}

