/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ecr.model.Layer;

public class LayerUnmarshaller
implements Unmarshaller<Layer, JsonUnmarshallerContext> {
    private static LayerUnmarshaller INSTANCE;

    public Layer unmarshall(JsonUnmarshallerContext context) throws Exception {
        Layer.Builder layerBuilder = Layer.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("layerDigest", targetDepth)) {
                    context.nextToken();
                    layerBuilder.layerDigest((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("layerAvailability", targetDepth)) {
                    context.nextToken();
                    layerBuilder.layerAvailability((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("layerSize", targetDepth)) {
                    context.nextToken();
                    layerBuilder.layerSize((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
                if (context.testExpression("mediaType", targetDepth)) {
                    context.nextToken();
                    layerBuilder.mediaType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Layer)layerBuilder.build();
    }

    public static LayerUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LayerUnmarshaller();
        }
        return INSTANCE;
    }
}

