/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.transform;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.ecr.model.ImageIdentifier;

@SdkInternalApi
public class ImageIdentifierMarshaller {
    private static final MarshallingInfo<String> IMAGEDIGEST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("imageDigest").build();
    private static final MarshallingInfo<String> IMAGETAG_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("imageTag").build();
    private static final ImageIdentifierMarshaller instance = new ImageIdentifierMarshaller();

    public static ImageIdentifierMarshaller getInstance() {
        return instance;
    }

    public void marshall(ImageIdentifier imageIdentifier, ProtocolMarshaller protocolMarshaller) {
        if (imageIdentifier == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)imageIdentifier.imageDigest(), IMAGEDIGEST_BINDING);
            protocolMarshaller.marshall((Object)imageIdentifier.imageTag(), IMAGETAG_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

