/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ecr.model.RepositoryNameListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeRepositoriesRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeRepositoriesRequest> {
    private final String registryId;
    private final List<String> repositoryNames;
    private final String nextToken;
    private final Integer maxResults;

    private DescribeRepositoriesRequest(BuilderImpl builder) {
        this.registryId = builder.registryId;
        this.repositoryNames = builder.repositoryNames;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public String registryId() {
        return this.registryId;
    }

    public List<String> repositoryNames() {
        return this.repositoryNames;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.registryId() == null ? 0 : this.registryId().hashCode());
        hashCode = 31 * hashCode + (this.repositoryNames() == null ? 0 : this.repositoryNames().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        hashCode = 31 * hashCode + (this.maxResults() == null ? 0 : this.maxResults().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRepositoriesRequest)) {
            return false;
        }
        DescribeRepositoriesRequest other = (DescribeRepositoriesRequest)((Object)obj);
        if (other.registryId() == null ^ this.registryId() == null) {
            return false;
        }
        if (other.registryId() != null && !other.registryId().equals(this.registryId())) {
            return false;
        }
        if (other.repositoryNames() == null ^ this.repositoryNames() == null) {
            return false;
        }
        if (other.repositoryNames() != null && !other.repositoryNames().equals(this.repositoryNames())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.maxResults() == null ^ this.maxResults() == null) {
            return false;
        }
        return other.maxResults() == null || other.maxResults().equals(this.maxResults());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.registryId() != null) {
            sb.append("RegistryId: ").append(this.registryId()).append(",");
        }
        if (this.repositoryNames() != null) {
            sb.append("RepositoryNames: ").append(this.repositoryNames()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (this.maxResults() != null) {
            sb.append("MaxResults: ").append(this.maxResults()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String registryId;
        private List<String> repositoryNames;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRepositoriesRequest model) {
            this.setRegistryId(model.registryId);
            this.setRepositoryNames(model.repositoryNames);
            this.setNextToken(model.nextToken);
            this.setMaxResults(model.maxResults);
        }

        public final String getRegistryId() {
            return this.registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        public final Collection<String> getRepositoryNames() {
            return this.repositoryNames;
        }

        @Override
        public final Builder repositoryNames(Collection<String> repositoryNames) {
            this.repositoryNames = RepositoryNameListCopier.copy(repositoryNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder repositoryNames(String ... repositoryNames) {
            if (this.repositoryNames == null) {
                this.repositoryNames = new ArrayList<String>(repositoryNames.length);
            }
            for (String e : repositoryNames) {
                this.repositoryNames.add(e);
            }
            return this;
        }

        public final void setRepositoryNames(Collection<String> repositoryNames) {
            this.repositoryNames = RepositoryNameListCopier.copy(repositoryNames);
        }

        @SafeVarargs
        public final void setRepositoryNames(String ... repositoryNames) {
            if (this.repositoryNames == null) {
                this.repositoryNames = new ArrayList<String>(repositoryNames.length);
            }
            for (String e : repositoryNames) {
                this.repositoryNames.add(e);
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public DescribeRepositoriesRequest build() {
            return new DescribeRepositoriesRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeRepositoriesRequest> {
        public Builder registryId(String var1);

        public Builder repositoryNames(Collection<String> var1);

        public Builder repositoryNames(String ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);
    }
}

