/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.ecr.model.ImageFailure;
import software.amazon.awssdk.services.ecr.model.ImageFailureListCopier;
import software.amazon.awssdk.services.ecr.model.ImageIdentifier;
import software.amazon.awssdk.services.ecr.model.ImageIdentifierListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchDeleteImageResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, BatchDeleteImageResponse> {
    private final List<ImageIdentifier> imageIds;
    private final List<ImageFailure> failures;

    private BatchDeleteImageResponse(BuilderImpl builder) {
        this.imageIds = builder.imageIds;
        this.failures = builder.failures;
    }

    public List<ImageIdentifier> imageIds() {
        return this.imageIds;
    }

    public List<ImageFailure> failures() {
        return this.failures;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.imageIds() == null ? 0 : this.imageIds().hashCode());
        hashCode = 31 * hashCode + (this.failures() == null ? 0 : this.failures().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteImageResponse)) {
            return false;
        }
        BatchDeleteImageResponse other = (BatchDeleteImageResponse)((Object)obj);
        if (other.imageIds() == null ^ this.imageIds() == null) {
            return false;
        }
        if (other.imageIds() != null && !other.imageIds().equals(this.imageIds())) {
            return false;
        }
        if (other.failures() == null ^ this.failures() == null) {
            return false;
        }
        return other.failures() == null || other.failures().equals(this.failures());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.imageIds() != null) {
            sb.append("ImageIds: ").append(this.imageIds()).append(",");
        }
        if (this.failures() != null) {
            sb.append("Failures: ").append(this.failures()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<ImageIdentifier> imageIds;
        private List<ImageFailure> failures;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteImageResponse model) {
            this.setImageIds(model.imageIds);
            this.setFailures(model.failures);
        }

        public final Collection<ImageIdentifier> getImageIds() {
            return this.imageIds;
        }

        @Override
        public final Builder imageIds(Collection<ImageIdentifier> imageIds) {
            this.imageIds = ImageIdentifierListCopier.copy(imageIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageIds(ImageIdentifier ... imageIds) {
            if (this.imageIds == null) {
                this.imageIds = new ArrayList<ImageIdentifier>(imageIds.length);
            }
            for (ImageIdentifier e : imageIds) {
                this.imageIds.add(e);
            }
            return this;
        }

        public final void setImageIds(Collection<ImageIdentifier> imageIds) {
            this.imageIds = ImageIdentifierListCopier.copy(imageIds);
        }

        @SafeVarargs
        public final void setImageIds(ImageIdentifier ... imageIds) {
            if (this.imageIds == null) {
                this.imageIds = new ArrayList<ImageIdentifier>(imageIds.length);
            }
            for (ImageIdentifier e : imageIds) {
                this.imageIds.add(e);
            }
        }

        public final Collection<ImageFailure> getFailures() {
            return this.failures;
        }

        @Override
        public final Builder failures(Collection<ImageFailure> failures) {
            this.failures = ImageFailureListCopier.copy(failures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(ImageFailure ... failures) {
            if (this.failures == null) {
                this.failures = new ArrayList<ImageFailure>(failures.length);
            }
            for (ImageFailure e : failures) {
                this.failures.add(e);
            }
            return this;
        }

        public final void setFailures(Collection<ImageFailure> failures) {
            this.failures = ImageFailureListCopier.copy(failures);
        }

        @SafeVarargs
        public final void setFailures(ImageFailure ... failures) {
            if (this.failures == null) {
                this.failures = new ArrayList<ImageFailure>(failures.length);
            }
            for (ImageFailure e : failures) {
                this.failures.add(e);
            }
        }

        public BatchDeleteImageResponse build() {
            return new BatchDeleteImageResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchDeleteImageResponse> {
        public Builder imageIds(Collection<ImageIdentifier> var1);

        public Builder imageIds(ImageIdentifier ... var1);

        public Builder failures(Collection<ImageFailure> var1);

        public Builder failures(ImageFailure ... var1);
    }
}

