/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.ecr.model.ImageIdentifier;
import software.amazon.awssdk.services.ecr.model.ImageIdentifierListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class BatchDeleteImageRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, BatchDeleteImageRequest> {
    private final String registryId;
    private final String repositoryName;
    private final List<ImageIdentifier> imageIds;

    private BatchDeleteImageRequest(BuilderImpl builder) {
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.imageIds = builder.imageIds;
    }

    public String registryId() {
        return this.registryId;
    }

    public String repositoryName() {
        return this.repositoryName;
    }

    public List<ImageIdentifier> imageIds() {
        return this.imageIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.registryId() == null ? 0 : this.registryId().hashCode());
        hashCode = 31 * hashCode + (this.repositoryName() == null ? 0 : this.repositoryName().hashCode());
        hashCode = 31 * hashCode + (this.imageIds() == null ? 0 : this.imageIds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteImageRequest)) {
            return false;
        }
        BatchDeleteImageRequest other = (BatchDeleteImageRequest)((Object)obj);
        if (other.registryId() == null ^ this.registryId() == null) {
            return false;
        }
        if (other.registryId() != null && !other.registryId().equals(this.registryId())) {
            return false;
        }
        if (other.repositoryName() == null ^ this.repositoryName() == null) {
            return false;
        }
        if (other.repositoryName() != null && !other.repositoryName().equals(this.repositoryName())) {
            return false;
        }
        if (other.imageIds() == null ^ this.imageIds() == null) {
            return false;
        }
        return other.imageIds() == null || other.imageIds().equals(this.imageIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.registryId() != null) {
            sb.append("RegistryId: ").append(this.registryId()).append(",");
        }
        if (this.repositoryName() != null) {
            sb.append("RepositoryName: ").append(this.repositoryName()).append(",");
        }
        if (this.imageIds() != null) {
            sb.append("ImageIds: ").append(this.imageIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String registryId;
        private String repositoryName;
        private List<ImageIdentifier> imageIds;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteImageRequest model) {
            this.setRegistryId(model.registryId);
            this.setRepositoryName(model.repositoryName);
            this.setImageIds(model.imageIds);
        }

        public final String getRegistryId() {
            return this.registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final Collection<ImageIdentifier> getImageIds() {
            return this.imageIds;
        }

        @Override
        public final Builder imageIds(Collection<ImageIdentifier> imageIds) {
            this.imageIds = ImageIdentifierListCopier.copy(imageIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageIds(ImageIdentifier ... imageIds) {
            if (this.imageIds == null) {
                this.imageIds = new ArrayList<ImageIdentifier>(imageIds.length);
            }
            for (ImageIdentifier e : imageIds) {
                this.imageIds.add(e);
            }
            return this;
        }

        public final void setImageIds(Collection<ImageIdentifier> imageIds) {
            this.imageIds = ImageIdentifierListCopier.copy(imageIds);
        }

        @SafeVarargs
        public final void setImageIds(ImageIdentifier ... imageIds) {
            if (this.imageIds == null) {
                this.imageIds = new ArrayList<ImageIdentifier>(imageIds.length);
            }
            for (ImageIdentifier e : imageIds) {
                this.imageIds.add(e);
            }
        }

        public BatchDeleteImageRequest build() {
            return new BatchDeleteImageRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, BatchDeleteImageRequest> {
        public Builder registryId(String var1);

        public Builder repositoryName(String var1);

        public Builder imageIds(Collection<ImageIdentifier> var1);

        public Builder imageIds(ImageIdentifier ... var1);
    }
}

