/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <p>
 * This is the <i> Amazon EC2 Instance Connect API Reference</i>. It provides descriptions, syntax, and usage examples
 * for each of the actions for Amazon EC2 Instance Connect. Amazon EC2 Instance Connect enables system administrators to
 * publish one-time use SSH public keys to EC2, providing users a simple and secure way to connect to their instances.
 * </p>
 * <p>
 * To view the Amazon EC2 Instance Connect content in the <i> Amazon EC2 User Guide</i>, see <a
 * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Connect-using-EC2-Instance-Connect.html">Connect to your
 * Linux instance using EC2 Instance Connect</a>.
 * </p>
 * <p>
 * For Amazon EC2 APIs, see the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Welcome.html">Amazon EC2
 * API Reference</a>.
 * </p>
 */
package software.amazon.awssdk.services.ec2instanceconnect;