/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2instanceconnect;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.ec2instanceconnect.model.AuthException;
import software.amazon.awssdk.services.ec2instanceconnect.model.Ec2InstanceConnectException;
import software.amazon.awssdk.services.ec2instanceconnect.model.Ec2InstanceNotFoundException;
import software.amazon.awssdk.services.ec2instanceconnect.model.Ec2InstanceStateInvalidException;
import software.amazon.awssdk.services.ec2instanceconnect.model.Ec2InstanceTypeInvalidException;
import software.amazon.awssdk.services.ec2instanceconnect.model.Ec2InstanceUnavailableException;
import software.amazon.awssdk.services.ec2instanceconnect.model.InvalidArgsException;
import software.amazon.awssdk.services.ec2instanceconnect.model.SendSerialConsoleSshPublicKeyRequest;
import software.amazon.awssdk.services.ec2instanceconnect.model.SendSerialConsoleSshPublicKeyResponse;
import software.amazon.awssdk.services.ec2instanceconnect.model.SendSshPublicKeyRequest;
import software.amazon.awssdk.services.ec2instanceconnect.model.SendSshPublicKeyResponse;
import software.amazon.awssdk.services.ec2instanceconnect.model.SerialConsoleAccessDisabledException;
import software.amazon.awssdk.services.ec2instanceconnect.model.SerialConsoleSessionLimitExceededException;
import software.amazon.awssdk.services.ec2instanceconnect.model.SerialConsoleSessionUnavailableException;
import software.amazon.awssdk.services.ec2instanceconnect.model.SerialConsoleSessionUnsupportedException;
import software.amazon.awssdk.services.ec2instanceconnect.model.ServiceException;
import software.amazon.awssdk.services.ec2instanceconnect.model.ThrottlingException;

/**
 * Service client for accessing EC2 Instance Connect. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * This is the <i> Amazon EC2 Instance Connect API Reference</i>. It provides descriptions, syntax, and usage examples
 * for each of the actions for Amazon EC2 Instance Connect. Amazon EC2 Instance Connect enables system administrators to
 * publish one-time use SSH public keys to EC2, providing users a simple and secure way to connect to their instances.
 * </p>
 * <p>
 * To view the Amazon EC2 Instance Connect content in the <i> Amazon EC2 User Guide</i>, see <a
 * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Connect-using-EC2-Instance-Connect.html">Connect to your
 * Linux instance using EC2 Instance Connect</a>.
 * </p>
 * <p>
 * For Amazon EC2 APIs, see the <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Welcome.html">Amazon EC2
 * API Reference</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface Ec2InstanceConnectClient extends AwsClient {
    String SERVICE_NAME = "ec2-instance-connect";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "ec2-instance-connect";

    /**
     * <p>
     * Pushes an SSH public key to the specified EC2 instance for use by the specified user. The key remains for 60
     * seconds. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Connect-using-EC2-Instance-Connect.html">Connect to
     * your Linux instance using EC2 Instance Connect</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param sendSshPublicKeyRequest
     * @return Result of the SendSSHPublicKey operation returned by the service.
     * @throws AuthException
     *         Either your AWS credentials are not valid or you do not have access to the EC2 instance.
     * @throws InvalidArgsException
     *         One of the parameters is not valid.
     * @throws ServiceException
     *         The service encountered an error. Follow the instructions in the error message and try again.
     * @throws ThrottlingException
     *         The requests were made too frequently and have been throttled. Wait a while and try again. To increase
     *         the limit on your request frequency, contact AWS Support.
     * @throws Ec2InstanceNotFoundException
     *         The specified instance was not found.
     * @throws Ec2InstanceStateInvalidException
     *         Unable to connect because the instance is not in a valid state. Connecting to a stopped or terminated
     *         instance is not supported. If the instance is stopped, start your instance, and try to connect again.
     * @throws Ec2InstanceUnavailableException
     *         The instance is currently unavailable. Wait a few minutes and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2InstanceConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2InstanceConnectClient.SendSSHPublicKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-instance-connect-2018-04-02/SendSSHPublicKey"
     *      target="_top">AWS API Documentation</a>
     */
    default SendSshPublicKeyResponse sendSSHPublicKey(SendSshPublicKeyRequest sendSshPublicKeyRequest) throws AuthException,
            InvalidArgsException, ServiceException, ThrottlingException, Ec2InstanceNotFoundException,
            Ec2InstanceStateInvalidException, Ec2InstanceUnavailableException, AwsServiceException, SdkClientException,
            Ec2InstanceConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Pushes an SSH public key to the specified EC2 instance for use by the specified user. The key remains for 60
     * seconds. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Connect-using-EC2-Instance-Connect.html">Connect to
     * your Linux instance using EC2 Instance Connect</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendSshPublicKeyRequest.Builder} avoiding the need
     * to create one manually via {@link SendSshPublicKeyRequest#builder()}
     * </p>
     *
     * @param sendSshPublicKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2instanceconnect.model.SendSshPublicKeyRequest.Builder} to create
     *        a request.
     * @return Result of the SendSSHPublicKey operation returned by the service.
     * @throws AuthException
     *         Either your AWS credentials are not valid or you do not have access to the EC2 instance.
     * @throws InvalidArgsException
     *         One of the parameters is not valid.
     * @throws ServiceException
     *         The service encountered an error. Follow the instructions in the error message and try again.
     * @throws ThrottlingException
     *         The requests were made too frequently and have been throttled. Wait a while and try again. To increase
     *         the limit on your request frequency, contact AWS Support.
     * @throws Ec2InstanceNotFoundException
     *         The specified instance was not found.
     * @throws Ec2InstanceStateInvalidException
     *         Unable to connect because the instance is not in a valid state. Connecting to a stopped or terminated
     *         instance is not supported. If the instance is stopped, start your instance, and try to connect again.
     * @throws Ec2InstanceUnavailableException
     *         The instance is currently unavailable. Wait a few minutes and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2InstanceConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2InstanceConnectClient.SendSSHPublicKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ec2-instance-connect-2018-04-02/SendSSHPublicKey"
     *      target="_top">AWS API Documentation</a>
     */
    default SendSshPublicKeyResponse sendSSHPublicKey(Consumer<SendSshPublicKeyRequest.Builder> sendSshPublicKeyRequest)
            throws AuthException, InvalidArgsException, ServiceException, ThrottlingException, Ec2InstanceNotFoundException,
            Ec2InstanceStateInvalidException, Ec2InstanceUnavailableException, AwsServiceException, SdkClientException,
            Ec2InstanceConnectException {
        return sendSSHPublicKey(SendSshPublicKeyRequest.builder().applyMutation(sendSshPublicKeyRequest).build());
    }

    /**
     * <p>
     * Pushes an SSH public key to the specified EC2 instance. The key remains for 60 seconds, which gives you 60
     * seconds to establish a serial console connection to the instance using SSH. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-serial-console.html">EC2 Serial Console</a> in the
     * <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param sendSerialConsoleSshPublicKeyRequest
     * @return Result of the SendSerialConsoleSSHPublicKey operation returned by the service.
     * @throws AuthException
     *         Either your AWS credentials are not valid or you do not have access to the EC2 instance.
     * @throws SerialConsoleAccessDisabledException
     *         Your account is not authorized to use the EC2 Serial Console. To authorize your account, run the
     *         EnableSerialConsoleAccess API. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EnableSerialConsoleAccess.html"
     *         >EnableSerialConsoleAccess</a> in the <i>Amazon EC2 API Reference</i>.
     * @throws InvalidArgsException
     *         One of the parameters is not valid.
     * @throws ServiceException
     *         The service encountered an error. Follow the instructions in the error message and try again.
     * @throws ThrottlingException
     *         The requests were made too frequently and have been throttled. Wait a while and try again. To increase
     *         the limit on your request frequency, contact AWS Support.
     * @throws Ec2InstanceNotFoundException
     *         The specified instance was not found.
     * @throws Ec2InstanceTypeInvalidException
     *         The instance type is not supported for connecting via the serial console. Only Nitro instance types are
     *         currently supported.
     * @throws SerialConsoleSessionLimitExceededException
     *         The instance currently has 1 active serial console session. Only 1 session is supported at a time.
     * @throws SerialConsoleSessionUnavailableException
     *         Unable to start a serial console session. Please try again.
     * @throws Ec2InstanceStateInvalidException
     *         Unable to connect because the instance is not in a valid state. Connecting to a stopped or terminated
     *         instance is not supported. If the instance is stopped, start your instance, and try to connect again.
     * @throws Ec2InstanceUnavailableException
     *         The instance is currently unavailable. Wait a few minutes and try again.
     * @throws SerialConsoleSessionUnsupportedException
     *         Your instance's BIOS version is unsupported for serial console connection. Reboot your instance to update
     *         its BIOS, and then try again to connect.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2InstanceConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2InstanceConnectClient.SendSerialConsoleSSHPublicKey
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/ec2-instance-connect-2018-04-02/SendSerialConsoleSSHPublicKey"
     *      target="_top">AWS API Documentation</a>
     */
    default SendSerialConsoleSshPublicKeyResponse sendSerialConsoleSSHPublicKey(
            SendSerialConsoleSshPublicKeyRequest sendSerialConsoleSshPublicKeyRequest) throws AuthException,
            SerialConsoleAccessDisabledException, InvalidArgsException, ServiceException, ThrottlingException,
            Ec2InstanceNotFoundException, Ec2InstanceTypeInvalidException, SerialConsoleSessionLimitExceededException,
            SerialConsoleSessionUnavailableException, Ec2InstanceStateInvalidException, Ec2InstanceUnavailableException,
            SerialConsoleSessionUnsupportedException, AwsServiceException, SdkClientException, Ec2InstanceConnectException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Pushes an SSH public key to the specified EC2 instance. The key remains for 60 seconds, which gives you 60
     * seconds to establish a serial console connection to the instance using SSH. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-serial-console.html">EC2 Serial Console</a> in the
     * <i>Amazon EC2 User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SendSerialConsoleSshPublicKeyRequest.Builder}
     * avoiding the need to create one manually via {@link SendSerialConsoleSshPublicKeyRequest#builder()}
     * </p>
     *
     * @param sendSerialConsoleSshPublicKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.ec2instanceconnect.model.SendSerialConsoleSshPublicKeyRequest.Builder}
     *        to create a request.
     * @return Result of the SendSerialConsoleSSHPublicKey operation returned by the service.
     * @throws AuthException
     *         Either your AWS credentials are not valid or you do not have access to the EC2 instance.
     * @throws SerialConsoleAccessDisabledException
     *         Your account is not authorized to use the EC2 Serial Console. To authorize your account, run the
     *         EnableSerialConsoleAccess API. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_EnableSerialConsoleAccess.html"
     *         >EnableSerialConsoleAccess</a> in the <i>Amazon EC2 API Reference</i>.
     * @throws InvalidArgsException
     *         One of the parameters is not valid.
     * @throws ServiceException
     *         The service encountered an error. Follow the instructions in the error message and try again.
     * @throws ThrottlingException
     *         The requests were made too frequently and have been throttled. Wait a while and try again. To increase
     *         the limit on your request frequency, contact AWS Support.
     * @throws Ec2InstanceNotFoundException
     *         The specified instance was not found.
     * @throws Ec2InstanceTypeInvalidException
     *         The instance type is not supported for connecting via the serial console. Only Nitro instance types are
     *         currently supported.
     * @throws SerialConsoleSessionLimitExceededException
     *         The instance currently has 1 active serial console session. Only 1 session is supported at a time.
     * @throws SerialConsoleSessionUnavailableException
     *         Unable to start a serial console session. Please try again.
     * @throws Ec2InstanceStateInvalidException
     *         Unable to connect because the instance is not in a valid state. Connecting to a stopped or terminated
     *         instance is not supported. If the instance is stopped, start your instance, and try to connect again.
     * @throws Ec2InstanceUnavailableException
     *         The instance is currently unavailable. Wait a few minutes and try again.
     * @throws SerialConsoleSessionUnsupportedException
     *         Your instance's BIOS version is unsupported for serial console connection. Reboot your instance to update
     *         its BIOS, and then try again to connect.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws Ec2InstanceConnectException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample Ec2InstanceConnectClient.SendSerialConsoleSSHPublicKey
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/ec2-instance-connect-2018-04-02/SendSerialConsoleSSHPublicKey"
     *      target="_top">AWS API Documentation</a>
     */
    default SendSerialConsoleSshPublicKeyResponse sendSerialConsoleSSHPublicKey(
            Consumer<SendSerialConsoleSshPublicKeyRequest.Builder> sendSerialConsoleSshPublicKeyRequest) throws AuthException,
            SerialConsoleAccessDisabledException, InvalidArgsException, ServiceException, ThrottlingException,
            Ec2InstanceNotFoundException, Ec2InstanceTypeInvalidException, SerialConsoleSessionLimitExceededException,
            SerialConsoleSessionUnavailableException, Ec2InstanceStateInvalidException, Ec2InstanceUnavailableException,
            SerialConsoleSessionUnsupportedException, AwsServiceException, SdkClientException, Ec2InstanceConnectException {
        return sendSerialConsoleSSHPublicKey(SendSerialConsoleSshPublicKeyRequest.builder()
                .applyMutation(sendSerialConsoleSshPublicKeyRequest).build());
    }

    /**
     * Create a {@link Ec2InstanceConnectClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static Ec2InstanceConnectClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link Ec2InstanceConnectClient}.
     */
    static Ec2InstanceConnectClientBuilder builder() {
        return new DefaultEc2InstanceConnectClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default Ec2InstanceConnectServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
