/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2instanceconnect;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.ec2instanceconnect.Ec2InstanceConnectClient;
import software.amazon.awssdk.services.ec2instanceconnect.Ec2InstanceConnectServiceClientConfiguration;
import software.amazon.awssdk.services.ec2instanceconnect.internal.Ec2InstanceConnectServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.ec2instanceconnect.model.AuthException;
import software.amazon.awssdk.services.ec2instanceconnect.model.Ec2InstanceConnectException;
import software.amazon.awssdk.services.ec2instanceconnect.model.Ec2InstanceNotFoundException;
import software.amazon.awssdk.services.ec2instanceconnect.model.Ec2InstanceStateInvalidException;
import software.amazon.awssdk.services.ec2instanceconnect.model.Ec2InstanceTypeInvalidException;
import software.amazon.awssdk.services.ec2instanceconnect.model.Ec2InstanceUnavailableException;
import software.amazon.awssdk.services.ec2instanceconnect.model.InvalidArgsException;
import software.amazon.awssdk.services.ec2instanceconnect.model.SendSerialConsoleSshPublicKeyRequest;
import software.amazon.awssdk.services.ec2instanceconnect.model.SendSerialConsoleSshPublicKeyResponse;
import software.amazon.awssdk.services.ec2instanceconnect.model.SendSshPublicKeyRequest;
import software.amazon.awssdk.services.ec2instanceconnect.model.SendSshPublicKeyResponse;
import software.amazon.awssdk.services.ec2instanceconnect.model.SerialConsoleAccessDisabledException;
import software.amazon.awssdk.services.ec2instanceconnect.model.SerialConsoleSessionLimitExceededException;
import software.amazon.awssdk.services.ec2instanceconnect.model.SerialConsoleSessionUnavailableException;
import software.amazon.awssdk.services.ec2instanceconnect.model.ServiceException;
import software.amazon.awssdk.services.ec2instanceconnect.model.ThrottlingException;
import software.amazon.awssdk.services.ec2instanceconnect.transform.SendSerialConsoleSshPublicKeyRequestMarshaller;
import software.amazon.awssdk.services.ec2instanceconnect.transform.SendSshPublicKeyRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultEc2InstanceConnectClient
implements Ec2InstanceConnectClient {
    private static final Logger log = Logger.loggerFor(DefaultEc2InstanceConnectClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final Ec2InstanceConnectServiceClientConfiguration serviceClientConfiguration;

    protected DefaultEc2InstanceConnectClient(Ec2InstanceConnectServiceClientConfiguration serviceClientConfiguration, SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SendSshPublicKeyResponse sendSSHPublicKey(SendSshPublicKeyRequest sendSshPublicKeyRequest) throws AuthException, InvalidArgsException, ServiceException, ThrottlingException, Ec2InstanceNotFoundException, Ec2InstanceStateInvalidException, Ec2InstanceUnavailableException, AwsServiceException, SdkClientException, Ec2InstanceConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SendSshPublicKeyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)sendSshPublicKeyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEc2InstanceConnectClient.resolveMetricPublishers(clientConfiguration, sendSshPublicKeyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EC2 Instance Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SendSSHPublicKey");
            SendSshPublicKeyResponse sendSshPublicKeyResponse = (SendSshPublicKeyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SendSSHPublicKey").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)sendSshPublicKeyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SendSshPublicKeyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return sendSshPublicKeyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEc2InstanceConnectClient.lambda$sendSSHPublicKey$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SendSerialConsoleSshPublicKeyResponse sendSerialConsoleSSHPublicKey(SendSerialConsoleSshPublicKeyRequest sendSerialConsoleSshPublicKeyRequest) throws AuthException, SerialConsoleAccessDisabledException, InvalidArgsException, ServiceException, ThrottlingException, Ec2InstanceNotFoundException, Ec2InstanceTypeInvalidException, SerialConsoleSessionLimitExceededException, SerialConsoleSessionUnavailableException, Ec2InstanceStateInvalidException, Ec2InstanceUnavailableException, AwsServiceException, SdkClientException, Ec2InstanceConnectException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, SendSerialConsoleSshPublicKeyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)sendSerialConsoleSshPublicKeyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultEc2InstanceConnectClient.resolveMetricPublishers(clientConfiguration, sendSerialConsoleSshPublicKeyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"EC2 Instance Connect");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SendSerialConsoleSSHPublicKey");
            SendSerialConsoleSshPublicKeyResponse sendSerialConsoleSshPublicKeyResponse = (SendSerialConsoleSshPublicKeyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("SendSerialConsoleSSHPublicKey").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)sendSerialConsoleSshPublicKeyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new SendSerialConsoleSshPublicKeyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return sendSerialConsoleSshPublicKeyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultEc2InstanceConnectClient.lambda$sendSerialConsoleSSHPublicKey$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "ec2-instance-connect";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        Ec2InstanceConnectServiceClientConfigurationBuilder.BuilderInternal serviceConfigBuilder = Ec2InstanceConnectServiceClientConfigurationBuilder.builder(clientConfiguration.toBuilder());
        serviceConfigBuilder.overrideConfiguration(this.serviceClientConfiguration.overrideConfiguration());
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        return serviceConfigBuilder.buildSdkClientConfiguration();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(Ec2InstanceConnectException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("AuthException").exceptionBuilderSupplier(AuthException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EC2InstanceUnavailableException").exceptionBuilderSupplier(Ec2InstanceUnavailableException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SerialConsoleSessionLimitExceededException").exceptionBuilderSupplier(SerialConsoleSessionLimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SerialConsoleAccessDisabledException").exceptionBuilderSupplier(SerialConsoleAccessDisabledException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("SerialConsoleSessionUnavailableException").exceptionBuilderSupplier(SerialConsoleSessionUnavailableException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EC2InstanceTypeInvalidException").exceptionBuilderSupplier(Ec2InstanceTypeInvalidException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EC2InstanceStateInvalidException").exceptionBuilderSupplier(Ec2InstanceStateInvalidException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceException").exceptionBuilderSupplier(ServiceException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("EC2InstanceNotFoundException").exceptionBuilderSupplier(Ec2InstanceNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidArgsException").exceptionBuilderSupplier(InvalidArgsException::builder).httpStatusCode(Integer.valueOf(400)).build());
    }

    @Override
    public final Ec2InstanceConnectServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$sendSerialConsoleSSHPublicKey$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$sendSSHPublicKey$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

