/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.ReservedInstancesId;
import software.amazon.awssdk.services.ec2.model.ReservedInstancesModificationResult;
import software.amazon.awssdk.services.ec2.model.ReservedInstancesModificationResultListCopier;
import software.amazon.awssdk.services.ec2.model.ReservedIntancesIdsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReservedInstancesModification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReservedInstancesModification> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReservedInstancesModification.getter(ReservedInstancesModification::clientToken)).setter(ReservedInstancesModification.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("clientToken").build()}).build();
    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ReservedInstancesModification.getter(ReservedInstancesModification::createDate)).setter(ReservedInstancesModification.setter(Builder::createDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").unmarshallLocationName("createDate").build()}).build();
    private static final SdkField<Instant> EFFECTIVE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ReservedInstancesModification.getter(ReservedInstancesModification::effectiveDate)).setter(ReservedInstancesModification.setter(Builder::effectiveDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EffectiveDate").unmarshallLocationName("effectiveDate").build()}).build();
    private static final SdkField<List<ReservedInstancesModificationResult>> MODIFICATION_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ReservedInstancesModification.getter(ReservedInstancesModification::modificationResults)).setter(ReservedInstancesModification.setter(Builder::modificationResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModificationResultSet").unmarshallLocationName("modificationResultSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReservedInstancesModificationResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<ReservedInstancesId>> RESERVED_INSTANCES_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ReservedInstancesModification.getter(ReservedInstancesModification::reservedInstancesIds)).setter(ReservedInstancesModification.setter(Builder::reservedInstancesIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstancesSet").unmarshallLocationName("reservedInstancesSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ReservedInstancesId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> RESERVED_INSTANCES_MODIFICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReservedInstancesModification.getter(ReservedInstancesModification::reservedInstancesModificationId)).setter(ReservedInstancesModification.setter(Builder::reservedInstancesModificationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstancesModificationId").unmarshallLocationName("reservedInstancesModificationId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReservedInstancesModification.getter(ReservedInstancesModification::status)).setter(ReservedInstancesModification.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").unmarshallLocationName("status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ReservedInstancesModification.getter(ReservedInstancesModification::statusMessage)).setter(ReservedInstancesModification.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").unmarshallLocationName("statusMessage").build()}).build();
    private static final SdkField<Instant> UPDATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ReservedInstancesModification.getter(ReservedInstancesModification::updateDate)).setter(ReservedInstancesModification.setter(Builder::updateDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateDate").unmarshallLocationName("updateDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, CREATE_DATE_FIELD, EFFECTIVE_DATE_FIELD, MODIFICATION_RESULTS_FIELD, RESERVED_INSTANCES_IDS_FIELD, RESERVED_INSTANCES_MODIFICATION_ID_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, UPDATE_DATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String clientToken;
    private final Instant createDate;
    private final Instant effectiveDate;
    private final List<ReservedInstancesModificationResult> modificationResults;
    private final List<ReservedInstancesId> reservedInstancesIds;
    private final String reservedInstancesModificationId;
    private final String status;
    private final String statusMessage;
    private final Instant updateDate;

    private ReservedInstancesModification(BuilderImpl builder) {
        this.clientToken = builder.clientToken;
        this.createDate = builder.createDate;
        this.effectiveDate = builder.effectiveDate;
        this.modificationResults = builder.modificationResults;
        this.reservedInstancesIds = builder.reservedInstancesIds;
        this.reservedInstancesModificationId = builder.reservedInstancesModificationId;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.updateDate = builder.updateDate;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public Instant createDate() {
        return this.createDate;
    }

    public Instant effectiveDate() {
        return this.effectiveDate;
    }

    public List<ReservedInstancesModificationResult> modificationResults() {
        return this.modificationResults;
    }

    public List<ReservedInstancesId> reservedInstancesIds() {
        return this.reservedInstancesIds;
    }

    public String reservedInstancesModificationId() {
        return this.reservedInstancesModificationId;
    }

    public String status() {
        return this.status;
    }

    public String statusMessage() {
        return this.statusMessage;
    }

    public Instant updateDate() {
        return this.updateDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.createDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.effectiveDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.modificationResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedInstancesIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedInstancesModificationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReservedInstancesModification)) {
            return false;
        }
        ReservedInstancesModification other = (ReservedInstancesModification)obj;
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.createDate(), other.createDate()) && Objects.equals(this.effectiveDate(), other.effectiveDate()) && Objects.equals(this.modificationResults(), other.modificationResults()) && Objects.equals(this.reservedInstancesIds(), other.reservedInstancesIds()) && Objects.equals(this.reservedInstancesModificationId(), other.reservedInstancesModificationId()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.updateDate(), other.updateDate());
    }

    public String toString() {
        return ToString.builder((String)"ReservedInstancesModification").add("ClientToken", (Object)this.clientToken()).add("CreateDate", (Object)this.createDate()).add("EffectiveDate", (Object)this.effectiveDate()).add("ModificationResults", this.modificationResults()).add("ReservedInstancesIds", this.reservedInstancesIds()).add("ReservedInstancesModificationId", (Object)this.reservedInstancesModificationId()).add("Status", (Object)this.status()).add("StatusMessage", (Object)this.statusMessage()).add("UpdateDate", (Object)this.updateDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "CreateDate": {
                return Optional.ofNullable(clazz.cast(this.createDate()));
            }
            case "EffectiveDate": {
                return Optional.ofNullable(clazz.cast(this.effectiveDate()));
            }
            case "ModificationResults": {
                return Optional.ofNullable(clazz.cast(this.modificationResults()));
            }
            case "ReservedInstancesIds": {
                return Optional.ofNullable(clazz.cast(this.reservedInstancesIds()));
            }
            case "ReservedInstancesModificationId": {
                return Optional.ofNullable(clazz.cast(this.reservedInstancesModificationId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "UpdateDate": {
                return Optional.ofNullable(clazz.cast(this.updateDate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReservedInstancesModification, T> g) {
        return obj -> g.apply((ReservedInstancesModification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clientToken;
        private Instant createDate;
        private Instant effectiveDate;
        private List<ReservedInstancesModificationResult> modificationResults = DefaultSdkAutoConstructList.getInstance();
        private List<ReservedInstancesId> reservedInstancesIds = DefaultSdkAutoConstructList.getInstance();
        private String reservedInstancesModificationId;
        private String status;
        private String statusMessage;
        private Instant updateDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ReservedInstancesModification model) {
            this.clientToken(model.clientToken);
            this.createDate(model.createDate);
            this.effectiveDate(model.effectiveDate);
            this.modificationResults(model.modificationResults);
            this.reservedInstancesIds(model.reservedInstancesIds);
            this.reservedInstancesModificationId(model.reservedInstancesModificationId);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.updateDate(model.updateDate);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        public final Instant getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        public final Builder effectiveDate(Instant effectiveDate) {
            this.effectiveDate = effectiveDate;
            return this;
        }

        public final void setEffectiveDate(Instant effectiveDate) {
            this.effectiveDate = effectiveDate;
        }

        public final Collection<ReservedInstancesModificationResult.Builder> getModificationResults() {
            return this.modificationResults != null ? (Collection)this.modificationResults.stream().map(ReservedInstancesModificationResult::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder modificationResults(Collection<ReservedInstancesModificationResult> modificationResults) {
            this.modificationResults = ReservedInstancesModificationResultListCopier.copy(modificationResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modificationResults(ReservedInstancesModificationResult ... modificationResults) {
            this.modificationResults(Arrays.asList(modificationResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modificationResults(Consumer<ReservedInstancesModificationResult.Builder> ... modificationResults) {
            this.modificationResults(Stream.of(modificationResults).map(c -> (ReservedInstancesModificationResult)((ReservedInstancesModificationResult.Builder)ReservedInstancesModificationResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setModificationResults(Collection<ReservedInstancesModificationResult.BuilderImpl> modificationResults) {
            this.modificationResults = ReservedInstancesModificationResultListCopier.copyFromBuilder(modificationResults);
        }

        public final Collection<ReservedInstancesId.Builder> getReservedInstancesIds() {
            return this.reservedInstancesIds != null ? (Collection)this.reservedInstancesIds.stream().map(ReservedInstancesId::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder reservedInstancesIds(Collection<ReservedInstancesId> reservedInstancesIds) {
            this.reservedInstancesIds = ReservedIntancesIdsCopier.copy(reservedInstancesIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstancesIds(ReservedInstancesId ... reservedInstancesIds) {
            this.reservedInstancesIds(Arrays.asList(reservedInstancesIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstancesIds(Consumer<ReservedInstancesId.Builder> ... reservedInstancesIds) {
            this.reservedInstancesIds(Stream.of(reservedInstancesIds).map(c -> (ReservedInstancesId)((ReservedInstancesId.Builder)ReservedInstancesId.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReservedInstancesIds(Collection<ReservedInstancesId.BuilderImpl> reservedInstancesIds) {
            this.reservedInstancesIds = ReservedIntancesIdsCopier.copyFromBuilder(reservedInstancesIds);
        }

        public final String getReservedInstancesModificationId() {
            return this.reservedInstancesModificationId;
        }

        @Override
        public final Builder reservedInstancesModificationId(String reservedInstancesModificationId) {
            this.reservedInstancesModificationId = reservedInstancesModificationId;
            return this;
        }

        public final void setReservedInstancesModificationId(String reservedInstancesModificationId) {
            this.reservedInstancesModificationId = reservedInstancesModificationId;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public final Instant getUpdateDate() {
            return this.updateDate;
        }

        @Override
        public final Builder updateDate(Instant updateDate) {
            this.updateDate = updateDate;
            return this;
        }

        public final void setUpdateDate(Instant updateDate) {
            this.updateDate = updateDate;
        }

        public ReservedInstancesModification build() {
            return new ReservedInstancesModification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReservedInstancesModification> {
        public Builder clientToken(String var1);

        public Builder createDate(Instant var1);

        public Builder effectiveDate(Instant var1);

        public Builder modificationResults(Collection<ReservedInstancesModificationResult> var1);

        public Builder modificationResults(ReservedInstancesModificationResult ... var1);

        public Builder modificationResults(Consumer<ReservedInstancesModificationResult.Builder> ... var1);

        public Builder reservedInstancesIds(Collection<ReservedInstancesId> var1);

        public Builder reservedInstancesIds(ReservedInstancesId ... var1);

        public Builder reservedInstancesIds(Consumer<ReservedInstancesId.Builder> ... var1);

        public Builder reservedInstancesModificationId(String var1);

        public Builder status(String var1);

        public Builder statusMessage(String var1);

        public Builder updateDate(Instant var1);
    }
}

