/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.ImportInstanceVolumeDetailItem;
import software.amazon.awssdk.services.ec2.model.ImportInstanceVolumeDetailSetCopier;
import software.amazon.awssdk.services.ec2.model.PlatformValues;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImportInstanceTaskDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImportInstanceTaskDetails> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ImportInstanceTaskDetails.getter(ImportInstanceTaskDetails::description)).setter(ImportInstanceTaskDetails.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ImportInstanceTaskDetails.getter(ImportInstanceTaskDetails::instanceId)).setter(ImportInstanceTaskDetails.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").unmarshallLocationName("instanceId").build()}).build();
    private static final SdkField<String> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ImportInstanceTaskDetails.getter(ImportInstanceTaskDetails::platformAsString)).setter(ImportInstanceTaskDetails.setter(Builder::platform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Platform").unmarshallLocationName("platform").build()}).build();
    private static final SdkField<List<ImportInstanceVolumeDetailItem>> VOLUMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ImportInstanceTaskDetails.getter(ImportInstanceTaskDetails::volumes)).setter(ImportInstanceTaskDetails.setter(Builder::volumes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Volumes").unmarshallLocationName("volumes").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ImportInstanceVolumeDetailItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, INSTANCE_ID_FIELD, PLATFORM_FIELD, VOLUMES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String description;
    private final String instanceId;
    private final String platform;
    private final List<ImportInstanceVolumeDetailItem> volumes;

    private ImportInstanceTaskDetails(BuilderImpl builder) {
        this.description = builder.description;
        this.instanceId = builder.instanceId;
        this.platform = builder.platform;
        this.volumes = builder.volumes;
    }

    public String description() {
        return this.description;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public PlatformValues platform() {
        return PlatformValues.fromValue(this.platform);
    }

    public String platformAsString() {
        return this.platform;
    }

    public List<ImportInstanceVolumeDetailItem> volumes() {
        return this.volumes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportInstanceTaskDetails)) {
            return false;
        }
        ImportInstanceTaskDetails other = (ImportInstanceTaskDetails)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.platformAsString(), other.platformAsString()) && Objects.equals(this.volumes(), other.volumes());
    }

    public String toString() {
        return ToString.builder((String)"ImportInstanceTaskDetails").add("Description", (Object)this.description()).add("InstanceId", (Object)this.instanceId()).add("Platform", (Object)this.platformAsString()).add("Volumes", this.volumes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "Platform": {
                return Optional.ofNullable(clazz.cast(this.platformAsString()));
            }
            case "Volumes": {
                return Optional.ofNullable(clazz.cast(this.volumes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImportInstanceTaskDetails, T> g) {
        return obj -> g.apply((ImportInstanceTaskDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private String instanceId;
        private String platform;
        private List<ImportInstanceVolumeDetailItem> volumes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ImportInstanceTaskDetails model) {
            this.description(model.description);
            this.instanceId(model.instanceId);
            this.platform(model.platform);
            this.volumes(model.volumes);
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getPlatformAsString() {
            return this.platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(PlatformValues platform) {
            this.platform(platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final Collection<ImportInstanceVolumeDetailItem.Builder> getVolumes() {
            return this.volumes != null ? (Collection)this.volumes.stream().map(ImportInstanceVolumeDetailItem::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder volumes(Collection<ImportInstanceVolumeDetailItem> volumes) {
            this.volumes = ImportInstanceVolumeDetailSetCopier.copy(volumes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(ImportInstanceVolumeDetailItem ... volumes) {
            this.volumes(Arrays.asList(volumes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(Consumer<ImportInstanceVolumeDetailItem.Builder> ... volumes) {
            this.volumes(Stream.of(volumes).map(c -> (ImportInstanceVolumeDetailItem)((ImportInstanceVolumeDetailItem.Builder)ImportInstanceVolumeDetailItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVolumes(Collection<ImportInstanceVolumeDetailItem.BuilderImpl> volumes) {
            this.volumes = ImportInstanceVolumeDetailSetCopier.copyFromBuilder(volumes);
        }

        public ImportInstanceTaskDetails build() {
            return new ImportInstanceTaskDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImportInstanceTaskDetails> {
        public Builder description(String var1);

        public Builder instanceId(String var1);

        public Builder platform(String var1);

        public Builder platform(PlatformValues var1);

        public Builder volumes(Collection<ImportInstanceVolumeDetailItem> var1);

        public Builder volumes(ImportInstanceVolumeDetailItem ... var1);

        public Builder volumes(Consumer<ImportInstanceVolumeDetailItem.Builder> ... var1);
    }
}

