/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.services.ec2.model.Placement;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FleetLaunchTemplateOverridesRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FleetLaunchTemplateOverridesRequest> {
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FleetLaunchTemplateOverridesRequest.getter(FleetLaunchTemplateOverridesRequest::instanceTypeAsString)).setter(FleetLaunchTemplateOverridesRequest.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").unmarshallLocationName("InstanceType").build()}).build();
    private static final SdkField<String> MAX_PRICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FleetLaunchTemplateOverridesRequest.getter(FleetLaunchTemplateOverridesRequest::maxPrice)).setter(FleetLaunchTemplateOverridesRequest.setter(Builder::maxPrice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxPrice").unmarshallLocationName("MaxPrice").build()}).build();
    private static final SdkField<String> SUBNET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FleetLaunchTemplateOverridesRequest.getter(FleetLaunchTemplateOverridesRequest::subnetId)).setter(FleetLaunchTemplateOverridesRequest.setter(Builder::subnetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetId").unmarshallLocationName("SubnetId").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(FleetLaunchTemplateOverridesRequest.getter(FleetLaunchTemplateOverridesRequest::availabilityZone)).setter(FleetLaunchTemplateOverridesRequest.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").unmarshallLocationName("AvailabilityZone").build()}).build();
    private static final SdkField<Double> WEIGHTED_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(FleetLaunchTemplateOverridesRequest.getter(FleetLaunchTemplateOverridesRequest::weightedCapacity)).setter(FleetLaunchTemplateOverridesRequest.setter(Builder::weightedCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WeightedCapacity").unmarshallLocationName("WeightedCapacity").build()}).build();
    private static final SdkField<Double> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).getter(FleetLaunchTemplateOverridesRequest.getter(FleetLaunchTemplateOverridesRequest::priority)).setter(FleetLaunchTemplateOverridesRequest.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").unmarshallLocationName("Priority").build()}).build();
    private static final SdkField<Placement> PLACEMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(FleetLaunchTemplateOverridesRequest.getter(FleetLaunchTemplateOverridesRequest::placement)).setter(FleetLaunchTemplateOverridesRequest.setter(Builder::placement)).constructor(Placement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Placement").unmarshallLocationName("Placement").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_TYPE_FIELD, MAX_PRICE_FIELD, SUBNET_ID_FIELD, AVAILABILITY_ZONE_FIELD, WEIGHTED_CAPACITY_FIELD, PRIORITY_FIELD, PLACEMENT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String instanceType;
    private final String maxPrice;
    private final String subnetId;
    private final String availabilityZone;
    private final Double weightedCapacity;
    private final Double priority;
    private final Placement placement;

    private FleetLaunchTemplateOverridesRequest(BuilderImpl builder) {
        this.instanceType = builder.instanceType;
        this.maxPrice = builder.maxPrice;
        this.subnetId = builder.subnetId;
        this.availabilityZone = builder.availabilityZone;
        this.weightedCapacity = builder.weightedCapacity;
        this.priority = builder.priority;
        this.placement = builder.placement;
    }

    public InstanceType instanceType() {
        return InstanceType.fromValue(this.instanceType);
    }

    public String instanceTypeAsString() {
        return this.instanceType;
    }

    public String maxPrice() {
        return this.maxPrice;
    }

    public String subnetId() {
        return this.subnetId;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public Double weightedCapacity() {
        return this.weightedCapacity;
    }

    public Double priority() {
        return this.priority;
    }

    public Placement placement() {
        return this.placement;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxPrice());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.weightedCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.placement());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FleetLaunchTemplateOverridesRequest)) {
            return false;
        }
        FleetLaunchTemplateOverridesRequest other = (FleetLaunchTemplateOverridesRequest)obj;
        return Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.maxPrice(), other.maxPrice()) && Objects.equals(this.subnetId(), other.subnetId()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.weightedCapacity(), other.weightedCapacity()) && Objects.equals(this.priority(), other.priority()) && Objects.equals(this.placement(), other.placement());
    }

    public String toString() {
        return ToString.builder((String)"FleetLaunchTemplateOverridesRequest").add("InstanceType", (Object)this.instanceTypeAsString()).add("MaxPrice", (Object)this.maxPrice()).add("SubnetId", (Object)this.subnetId()).add("AvailabilityZone", (Object)this.availabilityZone()).add("WeightedCapacity", (Object)this.weightedCapacity()).add("Priority", (Object)this.priority()).add("Placement", (Object)this.placement()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "MaxPrice": {
                return Optional.ofNullable(clazz.cast(this.maxPrice()));
            }
            case "SubnetId": {
                return Optional.ofNullable(clazz.cast(this.subnetId()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "WeightedCapacity": {
                return Optional.ofNullable(clazz.cast(this.weightedCapacity()));
            }
            case "Priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "Placement": {
                return Optional.ofNullable(clazz.cast(this.placement()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FleetLaunchTemplateOverridesRequest, T> g) {
        return obj -> g.apply((FleetLaunchTemplateOverridesRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceType;
        private String maxPrice;
        private String subnetId;
        private String availabilityZone;
        private Double weightedCapacity;
        private Double priority;
        private Placement placement;

        private BuilderImpl() {
        }

        private BuilderImpl(FleetLaunchTemplateOverridesRequest model) {
            this.instanceType(model.instanceType);
            this.maxPrice(model.maxPrice);
            this.subnetId(model.subnetId);
            this.availabilityZone(model.availabilityZone);
            this.weightedCapacity(model.weightedCapacity);
            this.priority(model.priority);
            this.placement(model.placement);
        }

        public final String getInstanceTypeAsString() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getMaxPrice() {
            return this.maxPrice;
        }

        @Override
        public final Builder maxPrice(String maxPrice) {
            this.maxPrice = maxPrice;
            return this;
        }

        public final void setMaxPrice(String maxPrice) {
            this.maxPrice = maxPrice;
        }

        public final String getSubnetId() {
            return this.subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Double getWeightedCapacity() {
            return this.weightedCapacity;
        }

        @Override
        public final Builder weightedCapacity(Double weightedCapacity) {
            this.weightedCapacity = weightedCapacity;
            return this;
        }

        public final void setWeightedCapacity(Double weightedCapacity) {
            this.weightedCapacity = weightedCapacity;
        }

        public final Double getPriority() {
            return this.priority;
        }

        @Override
        public final Builder priority(Double priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Double priority) {
            this.priority = priority;
        }

        public final Placement.Builder getPlacement() {
            return this.placement != null ? this.placement.toBuilder() : null;
        }

        @Override
        public final Builder placement(Placement placement) {
            this.placement = placement;
            return this;
        }

        public final void setPlacement(Placement.BuilderImpl placement) {
            this.placement = placement != null ? placement.build() : null;
        }

        public FleetLaunchTemplateOverridesRequest build() {
            return new FleetLaunchTemplateOverridesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FleetLaunchTemplateOverridesRequest> {
        public Builder instanceType(String var1);

        public Builder instanceType(InstanceType var1);

        public Builder maxPrice(String var1);

        public Builder subnetId(String var1);

        public Builder availabilityZone(String var1);

        public Builder weightedCapacity(Double var1);

        public Builder priority(Double var1);

        public Builder placement(Placement var1);

        default public Builder placement(Consumer<Placement.Builder> placement) {
            return this.placement((Placement)((Placement.Builder)Placement.builder().applyMutation(placement)).build());
        }
    }
}

