/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.EgressOnlyInternetGateway;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateEgressOnlyInternetGatewayResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, CreateEgressOnlyInternetGatewayResponse> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateEgressOnlyInternetGatewayResponse.getter(CreateEgressOnlyInternetGatewayResponse::clientToken)).setter(CreateEgressOnlyInternetGatewayResponse.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("clientToken").build()}).build();
    private static final SdkField<EgressOnlyInternetGateway> EGRESS_ONLY_INTERNET_GATEWAY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateEgressOnlyInternetGatewayResponse.getter(CreateEgressOnlyInternetGatewayResponse::egressOnlyInternetGateway)).setter(CreateEgressOnlyInternetGatewayResponse.setter(Builder::egressOnlyInternetGateway)).constructor(EgressOnlyInternetGateway::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EgressOnlyInternetGateway").unmarshallLocationName("egressOnlyInternetGateway").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, EGRESS_ONLY_INTERNET_GATEWAY_FIELD));
    private final String clientToken;
    private final EgressOnlyInternetGateway egressOnlyInternetGateway;

    private CreateEgressOnlyInternetGatewayResponse(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.egressOnlyInternetGateway = builder.egressOnlyInternetGateway;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public EgressOnlyInternetGateway egressOnlyInternetGateway() {
        return this.egressOnlyInternetGateway;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.egressOnlyInternetGateway());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEgressOnlyInternetGatewayResponse)) {
            return false;
        }
        CreateEgressOnlyInternetGatewayResponse other = (CreateEgressOnlyInternetGatewayResponse)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.egressOnlyInternetGateway(), other.egressOnlyInternetGateway());
    }

    public String toString() {
        return ToString.builder((String)"CreateEgressOnlyInternetGatewayResponse").add("ClientToken", (Object)this.clientToken()).add("EgressOnlyInternetGateway", (Object)this.egressOnlyInternetGateway()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "EgressOnlyInternetGateway": {
                return Optional.ofNullable(clazz.cast(this.egressOnlyInternetGateway()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateEgressOnlyInternetGatewayResponse, T> g) {
        return obj -> g.apply((CreateEgressOnlyInternetGatewayResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String clientToken;
        private EgressOnlyInternetGateway egressOnlyInternetGateway;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEgressOnlyInternetGatewayResponse model) {
            super(model);
            this.clientToken(model.clientToken);
            this.egressOnlyInternetGateway(model.egressOnlyInternetGateway);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final EgressOnlyInternetGateway.Builder getEgressOnlyInternetGateway() {
            return this.egressOnlyInternetGateway != null ? this.egressOnlyInternetGateway.toBuilder() : null;
        }

        @Override
        public final Builder egressOnlyInternetGateway(EgressOnlyInternetGateway egressOnlyInternetGateway) {
            this.egressOnlyInternetGateway = egressOnlyInternetGateway;
            return this;
        }

        public final void setEgressOnlyInternetGateway(EgressOnlyInternetGateway.BuilderImpl egressOnlyInternetGateway) {
            this.egressOnlyInternetGateway = egressOnlyInternetGateway != null ? egressOnlyInternetGateway.build() : null;
        }

        @Override
        public CreateEgressOnlyInternetGatewayResponse build() {
            return new CreateEgressOnlyInternetGatewayResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateEgressOnlyInternetGatewayResponse> {
        public Builder clientToken(String var1);

        public Builder egressOnlyInternetGateway(EgressOnlyInternetGateway var1);

        default public Builder egressOnlyInternetGateway(Consumer<EgressOnlyInternetGateway.Builder> egressOnlyInternetGateway) {
            return this.egressOnlyInternetGateway((EgressOnlyInternetGateway)((EgressOnlyInternetGateway.Builder)EgressOnlyInternetGateway.builder().applyMutation(egressOnlyInternetGateway)).build());
        }
    }
}

