/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.PeeringConnectionOptionsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyVpcPeeringConnectionOptionsRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, ModifyVpcPeeringConnectionOptionsRequest> {
    private static final SdkField<PeeringConnectionOptionsRequest> ACCEPTER_PEERING_CONNECTION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ModifyVpcPeeringConnectionOptionsRequest.getter(ModifyVpcPeeringConnectionOptionsRequest::accepterPeeringConnectionOptions)).setter(ModifyVpcPeeringConnectionOptionsRequest.setter(Builder::accepterPeeringConnectionOptions)).constructor(PeeringConnectionOptionsRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccepterPeeringConnectionOptions").unmarshallLocationName("AccepterPeeringConnectionOptions").build()}).build();
    private static final SdkField<PeeringConnectionOptionsRequest> REQUESTER_PEERING_CONNECTION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ModifyVpcPeeringConnectionOptionsRequest.getter(ModifyVpcPeeringConnectionOptionsRequest::requesterPeeringConnectionOptions)).setter(ModifyVpcPeeringConnectionOptionsRequest.setter(Builder::requesterPeeringConnectionOptions)).constructor(PeeringConnectionOptionsRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequesterPeeringConnectionOptions").unmarshallLocationName("RequesterPeeringConnectionOptions").build()}).build();
    private static final SdkField<String> VPC_PEERING_CONNECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyVpcPeeringConnectionOptionsRequest.getter(ModifyVpcPeeringConnectionOptionsRequest::vpcPeeringConnectionId)).setter(ModifyVpcPeeringConnectionOptionsRequest.setter(Builder::vpcPeeringConnectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcPeeringConnectionId").unmarshallLocationName("VpcPeeringConnectionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCEPTER_PEERING_CONNECTION_OPTIONS_FIELD, REQUESTER_PEERING_CONNECTION_OPTIONS_FIELD, VPC_PEERING_CONNECTION_ID_FIELD));
    private final PeeringConnectionOptionsRequest accepterPeeringConnectionOptions;
    private final PeeringConnectionOptionsRequest requesterPeeringConnectionOptions;
    private final String vpcPeeringConnectionId;

    private ModifyVpcPeeringConnectionOptionsRequest(BuilderImpl builder) {
        super(builder);
        this.accepterPeeringConnectionOptions = builder.accepterPeeringConnectionOptions;
        this.requesterPeeringConnectionOptions = builder.requesterPeeringConnectionOptions;
        this.vpcPeeringConnectionId = builder.vpcPeeringConnectionId;
    }

    public PeeringConnectionOptionsRequest accepterPeeringConnectionOptions() {
        return this.accepterPeeringConnectionOptions;
    }

    public PeeringConnectionOptionsRequest requesterPeeringConnectionOptions() {
        return this.requesterPeeringConnectionOptions;
    }

    public String vpcPeeringConnectionId() {
        return this.vpcPeeringConnectionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accepterPeeringConnectionOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.requesterPeeringConnectionOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcPeeringConnectionId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVpcPeeringConnectionOptionsRequest)) {
            return false;
        }
        ModifyVpcPeeringConnectionOptionsRequest other = (ModifyVpcPeeringConnectionOptionsRequest)((Object)obj);
        return Objects.equals(this.accepterPeeringConnectionOptions(), other.accepterPeeringConnectionOptions()) && Objects.equals(this.requesterPeeringConnectionOptions(), other.requesterPeeringConnectionOptions()) && Objects.equals(this.vpcPeeringConnectionId(), other.vpcPeeringConnectionId());
    }

    public String toString() {
        return ToString.builder((String)"ModifyVpcPeeringConnectionOptionsRequest").add("AccepterPeeringConnectionOptions", (Object)this.accepterPeeringConnectionOptions()).add("RequesterPeeringConnectionOptions", (Object)this.requesterPeeringConnectionOptions()).add("VpcPeeringConnectionId", (Object)this.vpcPeeringConnectionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccepterPeeringConnectionOptions": {
                return Optional.ofNullable(clazz.cast(this.accepterPeeringConnectionOptions()));
            }
            case "RequesterPeeringConnectionOptions": {
                return Optional.ofNullable(clazz.cast(this.requesterPeeringConnectionOptions()));
            }
            case "VpcPeeringConnectionId": {
                return Optional.ofNullable(clazz.cast(this.vpcPeeringConnectionId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyVpcPeeringConnectionOptionsRequest, T> g) {
        return obj -> g.apply((ModifyVpcPeeringConnectionOptionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private PeeringConnectionOptionsRequest accepterPeeringConnectionOptions;
        private PeeringConnectionOptionsRequest requesterPeeringConnectionOptions;
        private String vpcPeeringConnectionId;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVpcPeeringConnectionOptionsRequest model) {
            super(model);
            this.accepterPeeringConnectionOptions(model.accepterPeeringConnectionOptions);
            this.requesterPeeringConnectionOptions(model.requesterPeeringConnectionOptions);
            this.vpcPeeringConnectionId(model.vpcPeeringConnectionId);
        }

        public final PeeringConnectionOptionsRequest.Builder getAccepterPeeringConnectionOptions() {
            return this.accepterPeeringConnectionOptions != null ? this.accepterPeeringConnectionOptions.toBuilder() : null;
        }

        @Override
        public final Builder accepterPeeringConnectionOptions(PeeringConnectionOptionsRequest accepterPeeringConnectionOptions) {
            this.accepterPeeringConnectionOptions = accepterPeeringConnectionOptions;
            return this;
        }

        public final void setAccepterPeeringConnectionOptions(PeeringConnectionOptionsRequest.BuilderImpl accepterPeeringConnectionOptions) {
            this.accepterPeeringConnectionOptions = accepterPeeringConnectionOptions != null ? accepterPeeringConnectionOptions.build() : null;
        }

        public final PeeringConnectionOptionsRequest.Builder getRequesterPeeringConnectionOptions() {
            return this.requesterPeeringConnectionOptions != null ? this.requesterPeeringConnectionOptions.toBuilder() : null;
        }

        @Override
        public final Builder requesterPeeringConnectionOptions(PeeringConnectionOptionsRequest requesterPeeringConnectionOptions) {
            this.requesterPeeringConnectionOptions = requesterPeeringConnectionOptions;
            return this;
        }

        public final void setRequesterPeeringConnectionOptions(PeeringConnectionOptionsRequest.BuilderImpl requesterPeeringConnectionOptions) {
            this.requesterPeeringConnectionOptions = requesterPeeringConnectionOptions != null ? requesterPeeringConnectionOptions.build() : null;
        }

        public final String getVpcPeeringConnectionId() {
            return this.vpcPeeringConnectionId;
        }

        @Override
        public final Builder vpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
            return this;
        }

        public final void setVpcPeeringConnectionId(String vpcPeeringConnectionId) {
            this.vpcPeeringConnectionId = vpcPeeringConnectionId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyVpcPeeringConnectionOptionsRequest build() {
            return new ModifyVpcPeeringConnectionOptionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyVpcPeeringConnectionOptionsRequest> {
        public Builder accepterPeeringConnectionOptions(PeeringConnectionOptionsRequest var1);

        default public Builder accepterPeeringConnectionOptions(Consumer<PeeringConnectionOptionsRequest.Builder> accepterPeeringConnectionOptions) {
            return this.accepterPeeringConnectionOptions((PeeringConnectionOptionsRequest)((PeeringConnectionOptionsRequest.Builder)PeeringConnectionOptionsRequest.builder().applyMutation(accepterPeeringConnectionOptions)).build());
        }

        public Builder requesterPeeringConnectionOptions(PeeringConnectionOptionsRequest var1);

        default public Builder requesterPeeringConnectionOptions(Consumer<PeeringConnectionOptionsRequest.Builder> requesterPeeringConnectionOptions) {
            return this.requesterPeeringConnectionOptions((PeeringConnectionOptionsRequest)((PeeringConnectionOptionsRequest.Builder)PeeringConnectionOptionsRequest.builder().applyMutation(requesterPeeringConnectionOptions)).build());
        }

        public Builder vpcPeeringConnectionId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

