/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EncryptionStateValue {
    ENABLING("enabling"),
    ENABLED("enabled"),
    DISABLING("disabling"),
    DISABLED("disabled"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EncryptionStateValue> VALUE_MAP;
    private final String value;

    private EncryptionStateValue(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EncryptionStateValue fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EncryptionStateValue> knownValues() {
        EnumSet<EncryptionStateValue> knownValues = EnumSet.allOf(EncryptionStateValue.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EncryptionStateValue.class, EncryptionStateValue::toString);
    }
}

