/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.GetIpamPrefixListResolverRulesRequest;
import software.amazon.awssdk.services.ec2.model.GetIpamPrefixListResolverRulesResponse;
import software.amazon.awssdk.services.ec2.model.IpamPrefixListResolverRule;

public class GetIpamPrefixListResolverRulesIterable
implements SdkIterable<GetIpamPrefixListResolverRulesResponse> {
    private final Ec2Client client;
    private final GetIpamPrefixListResolverRulesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetIpamPrefixListResolverRulesIterable(Ec2Client client, GetIpamPrefixListResolverRulesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetIpamPrefixListResolverRulesResponseFetcher();
    }

    public Iterator<GetIpamPrefixListResolverRulesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<IpamPrefixListResolverRule> rules() {
        Function<GetIpamPrefixListResolverRulesResponse, Iterator> getIterator = response -> {
            if (response != null && response.rules() != null) {
                return response.rules().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetIpamPrefixListResolverRulesResponseFetcher
    implements SyncPageFetcher<GetIpamPrefixListResolverRulesResponse> {
        private GetIpamPrefixListResolverRulesResponseFetcher() {
        }

        public boolean hasNextPage(GetIpamPrefixListResolverRulesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetIpamPrefixListResolverRulesResponse nextPage(GetIpamPrefixListResolverRulesResponse previousPage) {
            if (previousPage == null) {
                return GetIpamPrefixListResolverRulesIterable.this.client.getIpamPrefixListResolverRules(GetIpamPrefixListResolverRulesIterable.this.firstRequest);
            }
            return GetIpamPrefixListResolverRulesIterable.this.client.getIpamPrefixListResolverRules((GetIpamPrefixListResolverRulesRequest)((Object)GetIpamPrefixListResolverRulesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

