/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeIpamPrefixListResolverTargetsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeIpamPrefixListResolverTargetsResponse;
import software.amazon.awssdk.services.ec2.model.IpamPrefixListResolverTarget;

public class DescribeIpamPrefixListResolverTargetsIterable
implements SdkIterable<DescribeIpamPrefixListResolverTargetsResponse> {
    private final Ec2Client client;
    private final DescribeIpamPrefixListResolverTargetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeIpamPrefixListResolverTargetsIterable(Ec2Client client, DescribeIpamPrefixListResolverTargetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeIpamPrefixListResolverTargetsResponseFetcher();
    }

    public Iterator<DescribeIpamPrefixListResolverTargetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<IpamPrefixListResolverTarget> ipamPrefixListResolverTargets() {
        Function<DescribeIpamPrefixListResolverTargetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.ipamPrefixListResolverTargets() != null) {
                return response.ipamPrefixListResolverTargets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeIpamPrefixListResolverTargetsResponseFetcher
    implements SyncPageFetcher<DescribeIpamPrefixListResolverTargetsResponse> {
        private DescribeIpamPrefixListResolverTargetsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeIpamPrefixListResolverTargetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeIpamPrefixListResolverTargetsResponse nextPage(DescribeIpamPrefixListResolverTargetsResponse previousPage) {
            if (previousPage == null) {
                return DescribeIpamPrefixListResolverTargetsIterable.this.client.describeIpamPrefixListResolverTargets(DescribeIpamPrefixListResolverTargetsIterable.this.firstRequest);
            }
            return DescribeIpamPrefixListResolverTargetsIterable.this.client.describeIpamPrefixListResolverTargets((DescribeIpamPrefixListResolverTargetsRequest)((Object)DescribeIpamPrefixListResolverTargetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

