/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeImageReferencesResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeImageReferencesResponse.Builder, DescribeImageReferencesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeImageReferencesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final SdkField<List<ImageReference>> IMAGE_REFERENCES_FIELD = SdkField
            .<List<ImageReference>> builder(MarshallingType.LIST)
            .memberName("ImageReferences")
            .getter(getter(DescribeImageReferencesResponse::imageReferences))
            .setter(setter(Builder::imageReferences))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageReferenceSet")
                    .unmarshallLocationName("imageReferenceSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<ImageReference> builder(MarshallingType.SDK_POJO)
                                            .constructor(ImageReference::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            IMAGE_REFERENCES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<ImageReference> imageReferences;

    private DescribeImageReferencesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.imageReferences = builder.imageReferences;
    }

    /**
     * <p>
     * The token to include in another request to get the next page of items. This value is <code>null</code> when there
     * are no more items to return.
     * </p>
     * 
     * @return The token to include in another request to get the next page of items. This value is <code>null</code>
     *         when there are no more items to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ImageReferences property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasImageReferences() {
        return imageReferences != null && !(imageReferences instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The resources that are referencing the specified images.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImageReferences} method.
     * </p>
     * 
     * @return The resources that are referencing the specified images.
     */
    public final List<ImageReference> imageReferences() {
        return imageReferences;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasImageReferences() ? imageReferences() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImageReferencesResponse)) {
            return false;
        }
        DescribeImageReferencesResponse other = (DescribeImageReferencesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasImageReferences() == other.hasImageReferences()
                && Objects.equals(imageReferences(), other.imageReferences());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeImageReferencesResponse").add("NextToken", nextToken())
                .add("ImageReferences", hasImageReferences() ? imageReferences() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ImageReferences":
            return Optional.ofNullable(clazz.cast(imageReferences()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("ImageReferenceSet", IMAGE_REFERENCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeImageReferencesResponse, T> g) {
        return obj -> g.apply((DescribeImageReferencesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeImageReferencesResponse> {
        /**
         * <p>
         * The token to include in another request to get the next page of items. This value is <code>null</code> when
         * there are no more items to return.
         * </p>
         * 
         * @param nextToken
         *        The token to include in another request to get the next page of items. This value is <code>null</code>
         *        when there are no more items to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The resources that are referencing the specified images.
         * </p>
         * 
         * @param imageReferences
         *        The resources that are referencing the specified images.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageReferences(Collection<ImageReference> imageReferences);

        /**
         * <p>
         * The resources that are referencing the specified images.
         * </p>
         * 
         * @param imageReferences
         *        The resources that are referencing the specified images.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageReferences(ImageReference... imageReferences);

        /**
         * <p>
         * The resources that are referencing the specified images.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.ImageReference.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.ImageReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.ImageReference.Builder#build()} is called immediately and
         * its result is passed to {@link #imageReferences(List<ImageReference>)}.
         * 
         * @param imageReferences
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.ImageReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageReferences(java.util.Collection<ImageReference>)
         */
        Builder imageReferences(Consumer<ImageReference.Builder>... imageReferences);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String nextToken;

        private List<ImageReference> imageReferences = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImageReferencesResponse model) {
            super(model);
            nextToken(model.nextToken);
            imageReferences(model.imageReferences);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ImageReference.Builder> getImageReferences() {
            List<ImageReference.Builder> result = ImageReferenceListCopier.copyToBuilder(this.imageReferences);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImageReferences(Collection<ImageReference.BuilderImpl> imageReferences) {
            this.imageReferences = ImageReferenceListCopier.copyFromBuilder(imageReferences);
        }

        @Override
        public final Builder imageReferences(Collection<ImageReference> imageReferences) {
            this.imageReferences = ImageReferenceListCopier.copy(imageReferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageReferences(ImageReference... imageReferences) {
            imageReferences(Arrays.asList(imageReferences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageReferences(Consumer<ImageReference.Builder>... imageReferences) {
            imageReferences(Stream.of(imageReferences).map(c -> ImageReference.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeImageReferencesResponse build() {
            return new DescribeImageReferencesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
