/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an IPAM policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IpamPolicyDocument implements SdkPojo, Serializable,
        ToCopyableBuilder<IpamPolicyDocument.Builder, IpamPolicyDocument> {
    private static final SdkField<String> IPAM_POLICY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IpamPolicyId")
            .getter(getter(IpamPolicyDocument::ipamPolicyId))
            .setter(setter(Builder::ipamPolicyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPolicyId")
                    .unmarshallLocationName("ipamPolicyId").build()).build();

    private static final SdkField<String> LOCALE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Locale")
            .getter(getter(IpamPolicyDocument::locale))
            .setter(setter(Builder::locale))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Locale")
                    .unmarshallLocationName("locale").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ResourceType")
            .getter(getter(IpamPolicyDocument::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType")
                    .unmarshallLocationName("resourceType").build()).build();

    private static final SdkField<List<IpamPolicyAllocationRule>> ALLOCATION_RULES_FIELD = SdkField
            .<List<IpamPolicyAllocationRule>> builder(MarshallingType.LIST)
            .memberName("AllocationRules")
            .getter(getter(IpamPolicyDocument::allocationRules))
            .setter(setter(Builder::allocationRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationRuleSet")
                    .unmarshallLocationName("allocationRuleSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<IpamPolicyAllocationRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(IpamPolicyAllocationRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IPAM_POLICY_ID_FIELD,
            LOCALE_FIELD, RESOURCE_TYPE_FIELD, ALLOCATION_RULES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String ipamPolicyId;

    private final String locale;

    private final String resourceType;

    private final List<IpamPolicyAllocationRule> allocationRules;

    private IpamPolicyDocument(BuilderImpl builder) {
        this.ipamPolicyId = builder.ipamPolicyId;
        this.locale = builder.locale;
        this.resourceType = builder.resourceType;
        this.allocationRules = builder.allocationRules;
    }

    /**
     * <p>
     * The ID of the IPAM policy.
     * </p>
     * 
     * @return The ID of the IPAM policy.
     */
    public final String ipamPolicyId() {
        return ipamPolicyId;
    }

    /**
     * <p>
     * The locale of the IPAM policy document.
     * </p>
     * 
     * @return The locale of the IPAM policy document.
     */
    public final String locale() {
        return locale;
    }

    /**
     * <p>
     * The resource type of the IPAM policy document.
     * </p>
     * <p>
     * The Amazon Web Services service or resource type that can use IP addresses through IPAM policies. Supported
     * services and resource types include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Elastic IP addresses
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link IpamPolicyResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The resource type of the IPAM policy document.</p>
     *         <p>
     *         The Amazon Web Services service or resource type that can use IP addresses through IPAM policies.
     *         Supported services and resource types include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Elastic IP addresses
     *         </p>
     *         </li>
     * @see IpamPolicyResourceType
     */
    public final IpamPolicyResourceType resourceType() {
        return IpamPolicyResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The resource type of the IPAM policy document.
     * </p>
     * <p>
     * The Amazon Web Services service or resource type that can use IP addresses through IPAM policies. Supported
     * services and resource types include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Elastic IP addresses
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link IpamPolicyResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The resource type of the IPAM policy document.</p>
     *         <p>
     *         The Amazon Web Services service or resource type that can use IP addresses through IPAM policies.
     *         Supported services and resource types include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Elastic IP addresses
     *         </p>
     *         </li>
     * @see IpamPolicyResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllocationRules property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAllocationRules() {
        return allocationRules != null && !(allocationRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The allocation rules in the IPAM policy document.
     * </p>
     * <p>
     * Allocation rules are optional configurations within an IPAM policy that map Amazon Web Services resource types to
     * specific IPAM pools. If no rules are defined, the resource types default to using Amazon-provided IP addresses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllocationRules} method.
     * </p>
     * 
     * @return The allocation rules in the IPAM policy document.</p>
     *         <p>
     *         Allocation rules are optional configurations within an IPAM policy that map Amazon Web Services resource
     *         types to specific IPAM pools. If no rules are defined, the resource types default to using
     *         Amazon-provided IP addresses.
     */
    public final List<IpamPolicyAllocationRule> allocationRules() {
        return allocationRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ipamPolicyId());
        hashCode = 31 * hashCode + Objects.hashCode(locale());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAllocationRules() ? allocationRules() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpamPolicyDocument)) {
            return false;
        }
        IpamPolicyDocument other = (IpamPolicyDocument) obj;
        return Objects.equals(ipamPolicyId(), other.ipamPolicyId()) && Objects.equals(locale(), other.locale())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && hasAllocationRules() == other.hasAllocationRules()
                && Objects.equals(allocationRules(), other.allocationRules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IpamPolicyDocument").add("IpamPolicyId", ipamPolicyId()).add("Locale", locale())
                .add("ResourceType", resourceTypeAsString())
                .add("AllocationRules", hasAllocationRules() ? allocationRules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IpamPolicyId":
            return Optional.ofNullable(clazz.cast(ipamPolicyId()));
        case "Locale":
            return Optional.ofNullable(clazz.cast(locale()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "AllocationRules":
            return Optional.ofNullable(clazz.cast(allocationRules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IpamPolicyId", IPAM_POLICY_ID_FIELD);
        map.put("Locale", LOCALE_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("AllocationRuleSet", ALLOCATION_RULES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IpamPolicyDocument, T> g) {
        return obj -> g.apply((IpamPolicyDocument) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IpamPolicyDocument> {
        /**
         * <p>
         * The ID of the IPAM policy.
         * </p>
         * 
         * @param ipamPolicyId
         *        The ID of the IPAM policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipamPolicyId(String ipamPolicyId);

        /**
         * <p>
         * The locale of the IPAM policy document.
         * </p>
         * 
         * @param locale
         *        The locale of the IPAM policy document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locale(String locale);

        /**
         * <p>
         * The resource type of the IPAM policy document.
         * </p>
         * <p>
         * The Amazon Web Services service or resource type that can use IP addresses through IPAM policies. Supported
         * services and resource types include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Elastic IP addresses
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceType
         *        The resource type of the IPAM policy document.</p>
         *        <p>
         *        The Amazon Web Services service or resource type that can use IP addresses through IPAM policies.
         *        Supported services and resource types include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Elastic IP addresses
         *        </p>
         *        </li>
         * @see IpamPolicyResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpamPolicyResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The resource type of the IPAM policy document.
         * </p>
         * <p>
         * The Amazon Web Services service or resource type that can use IP addresses through IPAM policies. Supported
         * services and resource types include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Elastic IP addresses
         * </p>
         * </li>
         * </ul>
         * 
         * @param resourceType
         *        The resource type of the IPAM policy document.</p>
         *        <p>
         *        The Amazon Web Services service or resource type that can use IP addresses through IPAM policies.
         *        Supported services and resource types include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Elastic IP addresses
         *        </p>
         *        </li>
         * @see IpamPolicyResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IpamPolicyResourceType
         */
        Builder resourceType(IpamPolicyResourceType resourceType);

        /**
         * <p>
         * The allocation rules in the IPAM policy document.
         * </p>
         * <p>
         * Allocation rules are optional configurations within an IPAM policy that map Amazon Web Services resource
         * types to specific IPAM pools. If no rules are defined, the resource types default to using Amazon-provided IP
         * addresses.
         * </p>
         * 
         * @param allocationRules
         *        The allocation rules in the IPAM policy document.</p>
         *        <p>
         *        Allocation rules are optional configurations within an IPAM policy that map Amazon Web Services
         *        resource types to specific IPAM pools. If no rules are defined, the resource types default to using
         *        Amazon-provided IP addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocationRules(Collection<IpamPolicyAllocationRule> allocationRules);

        /**
         * <p>
         * The allocation rules in the IPAM policy document.
         * </p>
         * <p>
         * Allocation rules are optional configurations within an IPAM policy that map Amazon Web Services resource
         * types to specific IPAM pools. If no rules are defined, the resource types default to using Amazon-provided IP
         * addresses.
         * </p>
         * 
         * @param allocationRules
         *        The allocation rules in the IPAM policy document.</p>
         *        <p>
         *        Allocation rules are optional configurations within an IPAM policy that map Amazon Web Services
         *        resource types to specific IPAM pools. If no rules are defined, the resource types default to using
         *        Amazon-provided IP addresses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocationRules(IpamPolicyAllocationRule... allocationRules);

        /**
         * <p>
         * The allocation rules in the IPAM policy document.
         * </p>
         * <p>
         * Allocation rules are optional configurations within an IPAM policy that map Amazon Web Services resource
         * types to specific IPAM pools. If no rules are defined, the resource types default to using Amazon-provided IP
         * addresses.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.IpamPolicyAllocationRule.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.ec2.model.IpamPolicyAllocationRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.IpamPolicyAllocationRule.Builder#build()} is called
         * immediately and its result is passed to {@link #allocationRules(List<IpamPolicyAllocationRule>)}.
         * 
         * @param allocationRules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.IpamPolicyAllocationRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #allocationRules(java.util.Collection<IpamPolicyAllocationRule>)
         */
        Builder allocationRules(Consumer<IpamPolicyAllocationRule.Builder>... allocationRules);
    }

    static final class BuilderImpl implements Builder {
        private String ipamPolicyId;

        private String locale;

        private String resourceType;

        private List<IpamPolicyAllocationRule> allocationRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(IpamPolicyDocument model) {
            ipamPolicyId(model.ipamPolicyId);
            locale(model.locale);
            resourceType(model.resourceType);
            allocationRules(model.allocationRules);
        }

        public final String getIpamPolicyId() {
            return ipamPolicyId;
        }

        public final void setIpamPolicyId(String ipamPolicyId) {
            this.ipamPolicyId = ipamPolicyId;
        }

        @Override
        public final Builder ipamPolicyId(String ipamPolicyId) {
            this.ipamPolicyId = ipamPolicyId;
            return this;
        }

        public final String getLocale() {
            return locale;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(IpamPolicyResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final List<IpamPolicyAllocationRule.Builder> getAllocationRules() {
            List<IpamPolicyAllocationRule.Builder> result = IpamPolicyAllocationRuleListCopier
                    .copyToBuilder(this.allocationRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAllocationRules(Collection<IpamPolicyAllocationRule.BuilderImpl> allocationRules) {
            this.allocationRules = IpamPolicyAllocationRuleListCopier.copyFromBuilder(allocationRules);
        }

        @Override
        public final Builder allocationRules(Collection<IpamPolicyAllocationRule> allocationRules) {
            this.allocationRules = IpamPolicyAllocationRuleListCopier.copy(allocationRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allocationRules(IpamPolicyAllocationRule... allocationRules) {
            allocationRules(Arrays.asList(allocationRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allocationRules(Consumer<IpamPolicyAllocationRule.Builder>... allocationRules) {
            allocationRules(Stream.of(allocationRules).map(c -> IpamPolicyAllocationRule.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public IpamPolicyDocument build() {
            return new IpamPolicyDocument(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
