/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCapacityReservationBillingRequestsResponse extends Ec2Response
        implements
        ToCopyableBuilder<DescribeCapacityReservationBillingRequestsResponse.Builder, DescribeCapacityReservationBillingRequestsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeCapacityReservationBillingRequestsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final SdkField<List<CapacityReservationBillingRequest>> CAPACITY_RESERVATION_BILLING_REQUESTS_FIELD = SdkField
            .<List<CapacityReservationBillingRequest>> builder(MarshallingType.LIST)
            .memberName("CapacityReservationBillingRequests")
            .getter(getter(DescribeCapacityReservationBillingRequestsResponse::capacityReservationBillingRequests))
            .setter(setter(Builder::capacityReservationBillingRequests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("CapacityReservationBillingRequestSet")
                    .unmarshallLocationName("capacityReservationBillingRequestSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<CapacityReservationBillingRequest> builder(MarshallingType.SDK_POJO)
                                            .constructor(CapacityReservationBillingRequest::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            CAPACITY_RESERVATION_BILLING_REQUESTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<CapacityReservationBillingRequest> capacityReservationBillingRequests;

    private DescribeCapacityReservationBillingRequestsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.capacityReservationBillingRequests = builder.capacityReservationBillingRequests;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the CapacityReservationBillingRequests
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasCapacityReservationBillingRequests() {
        return capacityReservationBillingRequests != null
                && !(capacityReservationBillingRequests instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCapacityReservationBillingRequests}
     * method.
     * </p>
     * 
     * @return Information about the request.
     */
    public final List<CapacityReservationBillingRequest> capacityReservationBillingRequests() {
        return capacityReservationBillingRequests;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasCapacityReservationBillingRequests() ? capacityReservationBillingRequests() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCapacityReservationBillingRequestsResponse)) {
            return false;
        }
        DescribeCapacityReservationBillingRequestsResponse other = (DescribeCapacityReservationBillingRequestsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasCapacityReservationBillingRequests() == other.hasCapacityReservationBillingRequests()
                && Objects.equals(capacityReservationBillingRequests(), other.capacityReservationBillingRequests());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DescribeCapacityReservationBillingRequestsResponse")
                .add("NextToken", nextToken())
                .add("CapacityReservationBillingRequests",
                        hasCapacityReservationBillingRequests() ? capacityReservationBillingRequests() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "CapacityReservationBillingRequests":
            return Optional.ofNullable(clazz.cast(capacityReservationBillingRequests()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("CapacityReservationBillingRequestSet", CAPACITY_RESERVATION_BILLING_REQUESTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeCapacityReservationBillingRequestsResponse, T> g) {
        return obj -> g.apply((DescribeCapacityReservationBillingRequestsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Response.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeCapacityReservationBillingRequestsResponse> {
        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Information about the request.
         * </p>
         * 
         * @param capacityReservationBillingRequests
         *        Information about the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityReservationBillingRequests(
                Collection<CapacityReservationBillingRequest> capacityReservationBillingRequests);

        /**
         * <p>
         * Information about the request.
         * </p>
         * 
         * @param capacityReservationBillingRequests
         *        Information about the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityReservationBillingRequests(CapacityReservationBillingRequest... capacityReservationBillingRequests);

        /**
         * <p>
         * Information about the request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.CapacityReservationBillingRequest.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.CapacityReservationBillingRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.CapacityReservationBillingRequest.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #capacityReservationBillingRequests(List<CapacityReservationBillingRequest>)}.
         * 
         * @param capacityReservationBillingRequests
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.CapacityReservationBillingRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacityReservationBillingRequests(java.util.Collection<CapacityReservationBillingRequest>)
         */
        Builder capacityReservationBillingRequests(
                Consumer<CapacityReservationBillingRequest.Builder>... capacityReservationBillingRequests);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private String nextToken;

        private List<CapacityReservationBillingRequest> capacityReservationBillingRequests = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCapacityReservationBillingRequestsResponse model) {
            super(model);
            nextToken(model.nextToken);
            capacityReservationBillingRequests(model.capacityReservationBillingRequests);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<CapacityReservationBillingRequest.Builder> getCapacityReservationBillingRequests() {
            List<CapacityReservationBillingRequest.Builder> result = CapacityReservationBillingRequestSetCopier
                    .copyToBuilder(this.capacityReservationBillingRequests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCapacityReservationBillingRequests(
                Collection<CapacityReservationBillingRequest.BuilderImpl> capacityReservationBillingRequests) {
            this.capacityReservationBillingRequests = CapacityReservationBillingRequestSetCopier
                    .copyFromBuilder(capacityReservationBillingRequests);
        }

        @Override
        public final Builder capacityReservationBillingRequests(
                Collection<CapacityReservationBillingRequest> capacityReservationBillingRequests) {
            this.capacityReservationBillingRequests = CapacityReservationBillingRequestSetCopier
                    .copy(capacityReservationBillingRequests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityReservationBillingRequests(
                CapacityReservationBillingRequest... capacityReservationBillingRequests) {
            capacityReservationBillingRequests(Arrays.asList(capacityReservationBillingRequests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityReservationBillingRequests(
                Consumer<CapacityReservationBillingRequest.Builder>... capacityReservationBillingRequests) {
            capacityReservationBillingRequests(Stream.of(capacityReservationBillingRequests)
                    .map(c -> CapacityReservationBillingRequest.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeCapacityReservationBillingRequestsResponse build() {
            return new DescribeCapacityReservationBillingRequestsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
