/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.IpamPolicy;
import software.amazon.awssdk.services.ec2.model.IpamPolicySetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeIpamPoliciesResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeIpamPoliciesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeIpamPoliciesResponse.getter(DescribeIpamPoliciesResponse::nextToken)).setter(DescribeIpamPoliciesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final SdkField<List<IpamPolicy>> IPAM_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IpamPolicies").getter(DescribeIpamPoliciesResponse.getter(DescribeIpamPoliciesResponse::ipamPolicies)).setter(DescribeIpamPoliciesResponse.setter(Builder::ipamPolicies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpamPolicySet").unmarshallLocationName("ipamPolicySet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IpamPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, IPAM_POLICIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeIpamPoliciesResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<IpamPolicy> ipamPolicies;

    private DescribeIpamPoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.ipamPolicies = builder.ipamPolicies;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasIpamPolicies() {
        return this.ipamPolicies != null && !(this.ipamPolicies instanceof SdkAutoConstructList);
    }

    public final List<IpamPolicy> ipamPolicies() {
        return this.ipamPolicies;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpamPolicies() ? this.ipamPolicies() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIpamPoliciesResponse)) {
            return false;
        }
        DescribeIpamPoliciesResponse other = (DescribeIpamPoliciesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasIpamPolicies() == other.hasIpamPolicies() && Objects.equals(this.ipamPolicies(), other.ipamPolicies());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeIpamPoliciesResponse").add("NextToken", (Object)this.nextToken()).add("IpamPolicies", this.hasIpamPolicies() ? this.ipamPolicies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "IpamPolicies": {
                return Optional.ofNullable(clazz.cast(this.ipamPolicies()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("IpamPolicySet", IPAM_POLICIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeIpamPoliciesResponse, T> g) {
        return obj -> g.apply((DescribeIpamPoliciesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<IpamPolicy> ipamPolicies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIpamPoliciesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.ipamPolicies(model.ipamPolicies);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<IpamPolicy.Builder> getIpamPolicies() {
            List<IpamPolicy.Builder> result = IpamPolicySetCopier.copyToBuilder(this.ipamPolicies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpamPolicies(Collection<IpamPolicy.BuilderImpl> ipamPolicies) {
            this.ipamPolicies = IpamPolicySetCopier.copyFromBuilder(ipamPolicies);
        }

        @Override
        public final Builder ipamPolicies(Collection<IpamPolicy> ipamPolicies) {
            this.ipamPolicies = IpamPolicySetCopier.copy(ipamPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipamPolicies(IpamPolicy ... ipamPolicies) {
            this.ipamPolicies(Arrays.asList(ipamPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipamPolicies(Consumer<IpamPolicy.Builder> ... ipamPolicies) {
            this.ipamPolicies(Stream.of(ipamPolicies).map(c -> (IpamPolicy)((IpamPolicy.Builder)IpamPolicy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeIpamPoliciesResponse build() {
            return new DescribeIpamPoliciesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeIpamPoliciesResponse> {
        public Builder nextToken(String var1);

        public Builder ipamPolicies(Collection<IpamPolicy> var1);

        public Builder ipamPolicies(IpamPolicy ... var1);

        public Builder ipamPolicies(Consumer<IpamPolicy.Builder> ... var1);
    }
}

