/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeRouteServerPeersResponse extends Ec2Response implements
        ToCopyableBuilder<DescribeRouteServerPeersResponse.Builder, DescribeRouteServerPeersResponse> {
    private static final SdkField<List<RouteServerPeer>> ROUTE_SERVER_PEERS_FIELD = SdkField
            .<List<RouteServerPeer>> builder(MarshallingType.LIST)
            .memberName("RouteServerPeers")
            .getter(getter(DescribeRouteServerPeersResponse::routeServerPeers))
            .setter(setter(Builder::routeServerPeers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RouteServerPeerSet")
                    .unmarshallLocationName("routeServerPeerSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<RouteServerPeer> builder(MarshallingType.SDK_POJO)
                                            .constructor(RouteServerPeer::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("NextToken")
            .getter(getter(DescribeRouteServerPeersResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken")
                    .unmarshallLocationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ROUTE_SERVER_PEERS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<RouteServerPeer> routeServerPeers;

    private final String nextToken;

    private DescribeRouteServerPeersResponse(BuilderImpl builder) {
        super(builder);
        this.routeServerPeers = builder.routeServerPeers;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the RouteServerPeers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRouteServerPeers() {
        return routeServerPeers != null && !(routeServerPeers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the described route server peers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRouteServerPeers} method.
     * </p>
     * 
     * @return Information about the described route server peers.
     */
    public final List<RouteServerPeer> routeServerPeers() {
        return routeServerPeers;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRouteServerPeers() ? routeServerPeers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRouteServerPeersResponse)) {
            return false;
        }
        DescribeRouteServerPeersResponse other = (DescribeRouteServerPeersResponse) obj;
        return hasRouteServerPeers() == other.hasRouteServerPeers()
                && Objects.equals(routeServerPeers(), other.routeServerPeers()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeRouteServerPeersResponse")
                .add("RouteServerPeers", hasRouteServerPeers() ? routeServerPeers() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RouteServerPeers":
            return Optional.ofNullable(clazz.cast(routeServerPeers()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RouteServerPeerSet", ROUTE_SERVER_PEERS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeRouteServerPeersResponse, T> g) {
        return obj -> g.apply((DescribeRouteServerPeersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends Ec2Response.Builder, SdkPojo, CopyableBuilder<Builder, DescribeRouteServerPeersResponse> {
        /**
         * <p>
         * Information about the described route server peers.
         * </p>
         * 
         * @param routeServerPeers
         *        Information about the described route server peers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeServerPeers(Collection<RouteServerPeer> routeServerPeers);

        /**
         * <p>
         * Information about the described route server peers.
         * </p>
         * 
         * @param routeServerPeers
         *        Information about the described route server peers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeServerPeers(RouteServerPeer... routeServerPeers);

        /**
         * <p>
         * Information about the described route server peers.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.RouteServerPeer.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ec2.model.RouteServerPeer#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ec2.model.RouteServerPeer.Builder#build()} is called immediately and
         * its result is passed to {@link #routeServerPeers(List<RouteServerPeer>)}.
         * 
         * @param routeServerPeers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ec2.model.RouteServerPeer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #routeServerPeers(java.util.Collection<RouteServerPeer>)
         */
        Builder routeServerPeers(Consumer<RouteServerPeer.Builder>... routeServerPeers);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends Ec2Response.BuilderImpl implements Builder {
        private List<RouteServerPeer> routeServerPeers = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRouteServerPeersResponse model) {
            super(model);
            routeServerPeers(model.routeServerPeers);
            nextToken(model.nextToken);
        }

        public final List<RouteServerPeer.Builder> getRouteServerPeers() {
            List<RouteServerPeer.Builder> result = RouteServerPeersListCopier.copyToBuilder(this.routeServerPeers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRouteServerPeers(Collection<RouteServerPeer.BuilderImpl> routeServerPeers) {
            this.routeServerPeers = RouteServerPeersListCopier.copyFromBuilder(routeServerPeers);
        }

        @Override
        public final Builder routeServerPeers(Collection<RouteServerPeer> routeServerPeers) {
            this.routeServerPeers = RouteServerPeersListCopier.copy(routeServerPeers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeServerPeers(RouteServerPeer... routeServerPeers) {
            routeServerPeers(Arrays.asList(routeServerPeers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeServerPeers(Consumer<RouteServerPeer.Builder>... routeServerPeers) {
            routeServerPeers(Stream.of(routeServerPeers).map(c -> RouteServerPeer.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeRouteServerPeersResponse build() {
            return new DescribeRouteServerPeersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
