/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SecurityGroupForVpc
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SecurityGroupForVpc> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(SecurityGroupForVpc.getter(SecurityGroupForVpc::description)).setter(SecurityGroupForVpc.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupName").getter(SecurityGroupForVpc.getter(SecurityGroupForVpc::groupName)).setter(SecurityGroupForVpc.setter(Builder::groupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").unmarshallLocationName("groupName").build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(SecurityGroupForVpc.getter(SecurityGroupForVpc::ownerId)).setter(SecurityGroupForVpc.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").unmarshallLocationName("ownerId").build()}).build();
    private static final SdkField<String> GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupId").getter(SecurityGroupForVpc.getter(SecurityGroupForVpc::groupId)).setter(SecurityGroupForVpc.setter(Builder::groupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId").unmarshallLocationName("groupId").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(SecurityGroupForVpc.getter(SecurityGroupForVpc::tags)).setter(SecurityGroupForVpc.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> PRIMARY_VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrimaryVpcId").getter(SecurityGroupForVpc.getter(SecurityGroupForVpc::primaryVpcId)).setter(SecurityGroupForVpc.setter(Builder::primaryVpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryVpcId").unmarshallLocationName("primaryVpcId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, GROUP_NAME_FIELD, OWNER_ID_FIELD, GROUP_ID_FIELD, TAGS_FIELD, PRIMARY_VPC_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SecurityGroupForVpc.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String description;
    private final String groupName;
    private final String ownerId;
    private final String groupId;
    private final List<Tag> tags;
    private final String primaryVpcId;

    private SecurityGroupForVpc(BuilderImpl builder) {
        this.description = builder.description;
        this.groupName = builder.groupName;
        this.ownerId = builder.ownerId;
        this.groupId = builder.groupId;
        this.tags = builder.tags;
        this.primaryVpcId = builder.primaryVpcId;
    }

    public final String description() {
        return this.description;
    }

    public final String groupName() {
        return this.groupName;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final String groupId() {
        return this.groupId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String primaryVpcId() {
        return this.primaryVpcId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.primaryVpcId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityGroupForVpc)) {
            return false;
        }
        SecurityGroupForVpc other = (SecurityGroupForVpc)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.groupId(), other.groupId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.primaryVpcId(), other.primaryVpcId());
    }

    public final String toString() {
        return ToString.builder((String)"SecurityGroupForVpc").add("Description", (Object)this.description()).add("GroupName", (Object)this.groupName()).add("OwnerId", (Object)this.ownerId()).add("GroupId", (Object)this.groupId()).add("Tags", this.hasTags() ? this.tags() : null).add("PrimaryVpcId", (Object)this.primaryVpcId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "GroupName": {
                return Optional.ofNullable(clazz.cast(this.groupName()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "GroupId": {
                return Optional.ofNullable(clazz.cast(this.groupId()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "PrimaryVpcId": {
                return Optional.ofNullable(clazz.cast(this.primaryVpcId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Description", DESCRIPTION_FIELD);
        map.put("GroupName", GROUP_NAME_FIELD);
        map.put("OwnerId", OWNER_ID_FIELD);
        map.put("GroupId", GROUP_ID_FIELD);
        map.put("TagSet", TAGS_FIELD);
        map.put("PrimaryVpcId", PRIMARY_VPC_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SecurityGroupForVpc, T> g) {
        return obj -> g.apply((SecurityGroupForVpc)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private String groupName;
        private String ownerId;
        private String groupId;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String primaryVpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(SecurityGroupForVpc model) {
            this.description(model.description);
            this.groupName(model.groupName);
            this.ownerId(model.ownerId);
            this.groupId(model.groupId);
            this.tags(model.tags);
            this.primaryVpcId(model.primaryVpcId);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getGroupName() {
            return this.groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getGroupId() {
            return this.groupId;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPrimaryVpcId() {
            return this.primaryVpcId;
        }

        public final void setPrimaryVpcId(String primaryVpcId) {
            this.primaryVpcId = primaryVpcId;
        }

        @Override
        public final Builder primaryVpcId(String primaryVpcId) {
            this.primaryVpcId = primaryVpcId;
            return this;
        }

        public SecurityGroupForVpc build() {
            return new SecurityGroupForVpc(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SecurityGroupForVpc> {
        public Builder description(String var1);

        public Builder groupName(String var1);

        public Builder ownerId(String var1);

        public Builder groupId(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder primaryVpcId(String var1);
    }
}

