/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a Capacity Manager data export configuration, including export settings, delivery status,
 * and recent export activity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CapacityManagerDataExportResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<CapacityManagerDataExportResponse.Builder, CapacityManagerDataExportResponse> {
    private static final SdkField<String> CAPACITY_MANAGER_DATA_EXPORT_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CapacityManagerDataExportId")
            .getter(getter(CapacityManagerDataExportResponse::capacityManagerDataExportId))
            .setter(setter(Builder::capacityManagerDataExportId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityManagerDataExportId")
                    .unmarshallLocationName("capacityManagerDataExportId").build()).build();

    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("S3BucketName")
            .getter(getter(CapacityManagerDataExportResponse::s3BucketName))
            .setter(setter(Builder::s3BucketName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketName")
                    .unmarshallLocationName("s3BucketName").build()).build();

    private static final SdkField<String> S3_BUCKET_PREFIX_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("S3BucketPrefix")
            .getter(getter(CapacityManagerDataExportResponse::s3BucketPrefix))
            .setter(setter(Builder::s3BucketPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketPrefix")
                    .unmarshallLocationName("s3BucketPrefix").build()).build();

    private static final SdkField<String> SCHEDULE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Schedule")
            .getter(getter(CapacityManagerDataExportResponse::scheduleAsString))
            .setter(setter(Builder::schedule))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule")
                    .unmarshallLocationName("schedule").build()).build();

    private static final SdkField<String> OUTPUT_FORMAT_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("OutputFormat")
            .getter(getter(CapacityManagerDataExportResponse::outputFormatAsString))
            .setter(setter(Builder::outputFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputFormat")
                    .unmarshallLocationName("outputFormat").build()).build();

    private static final SdkField<Instant> CREATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateTime")
            .getter(getter(CapacityManagerDataExportResponse::createTime))
            .setter(setter(Builder::createTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateTime")
                    .unmarshallLocationName("createTime").build()).build();

    private static final SdkField<String> LATEST_DELIVERY_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LatestDeliveryStatus")
            .getter(getter(CapacityManagerDataExportResponse::latestDeliveryStatusAsString))
            .setter(setter(Builder::latestDeliveryStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestDeliveryStatus")
                    .unmarshallLocationName("latestDeliveryStatus").build()).build();

    private static final SdkField<String> LATEST_DELIVERY_STATUS_MESSAGE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LatestDeliveryStatusMessage")
            .getter(getter(CapacityManagerDataExportResponse::latestDeliveryStatusMessage))
            .setter(setter(Builder::latestDeliveryStatusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestDeliveryStatusMessage")
                    .unmarshallLocationName("latestDeliveryStatusMessage").build()).build();

    private static final SdkField<String> LATEST_DELIVERY_S3_LOCATION_URI_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("LatestDeliveryS3LocationUri")
            .getter(getter(CapacityManagerDataExportResponse::latestDeliveryS3LocationUri))
            .setter(setter(Builder::latestDeliveryS3LocationUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestDeliveryS3LocationUri")
                    .unmarshallLocationName("latestDeliveryS3LocationUri").build()).build();

    private static final SdkField<Instant> LATEST_DELIVERY_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LatestDeliveryTime")
            .getter(getter(CapacityManagerDataExportResponse::latestDeliveryTime))
            .setter(setter(Builder::latestDeliveryTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestDeliveryTime")
                    .unmarshallLocationName("latestDeliveryTime").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CapacityManagerDataExportResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet")
                    .unmarshallLocationName("tagSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("item")
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("Item").unmarshallLocationName("item").build()).build())
                            .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CAPACITY_MANAGER_DATA_EXPORT_ID_FIELD, S3_BUCKET_NAME_FIELD, S3_BUCKET_PREFIX_FIELD, SCHEDULE_FIELD,
            OUTPUT_FORMAT_FIELD, CREATE_TIME_FIELD, LATEST_DELIVERY_STATUS_FIELD, LATEST_DELIVERY_STATUS_MESSAGE_FIELD,
            LATEST_DELIVERY_S3_LOCATION_URI_FIELD, LATEST_DELIVERY_TIME_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String capacityManagerDataExportId;

    private final String s3BucketName;

    private final String s3BucketPrefix;

    private final String schedule;

    private final String outputFormat;

    private final Instant createTime;

    private final String latestDeliveryStatus;

    private final String latestDeliveryStatusMessage;

    private final String latestDeliveryS3LocationUri;

    private final Instant latestDeliveryTime;

    private final List<Tag> tags;

    private CapacityManagerDataExportResponse(BuilderImpl builder) {
        this.capacityManagerDataExportId = builder.capacityManagerDataExportId;
        this.s3BucketName = builder.s3BucketName;
        this.s3BucketPrefix = builder.s3BucketPrefix;
        this.schedule = builder.schedule;
        this.outputFormat = builder.outputFormat;
        this.createTime = builder.createTime;
        this.latestDeliveryStatus = builder.latestDeliveryStatus;
        this.latestDeliveryStatusMessage = builder.latestDeliveryStatusMessage;
        this.latestDeliveryS3LocationUri = builder.latestDeliveryS3LocationUri;
        this.latestDeliveryTime = builder.latestDeliveryTime;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The unique identifier for the data export configuration.
     * </p>
     * 
     * @return The unique identifier for the data export configuration.
     */
    public final String capacityManagerDataExportId() {
        return capacityManagerDataExportId;
    }

    /**
     * <p>
     * The name of the S3 bucket where export files are delivered.
     * </p>
     * 
     * @return The name of the S3 bucket where export files are delivered.
     */
    public final String s3BucketName() {
        return s3BucketName;
    }

    /**
     * <p>
     * The S3 key prefix used for organizing export files within the bucket.
     * </p>
     * 
     * @return The S3 key prefix used for organizing export files within the bucket.
     */
    public final String s3BucketPrefix() {
        return s3BucketPrefix;
    }

    /**
     * <p>
     * The frequency at which data exports are generated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #schedule} will
     * return {@link Schedule#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scheduleAsString}.
     * </p>
     * 
     * @return The frequency at which data exports are generated.
     * @see Schedule
     */
    public final Schedule schedule() {
        return Schedule.fromValue(schedule);
    }

    /**
     * <p>
     * The frequency at which data exports are generated.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #schedule} will
     * return {@link Schedule#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scheduleAsString}.
     * </p>
     * 
     * @return The frequency at which data exports are generated.
     * @see Schedule
     */
    public final String scheduleAsString() {
        return schedule;
    }

    /**
     * <p>
     * The file format of the exported data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputFormat} will
     * return {@link OutputFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #outputFormatAsString}.
     * </p>
     * 
     * @return The file format of the exported data.
     * @see OutputFormat
     */
    public final OutputFormat outputFormat() {
        return OutputFormat.fromValue(outputFormat);
    }

    /**
     * <p>
     * The file format of the exported data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #outputFormat} will
     * return {@link OutputFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #outputFormatAsString}.
     * </p>
     * 
     * @return The file format of the exported data.
     * @see OutputFormat
     */
    public final String outputFormatAsString() {
        return outputFormat;
    }

    /**
     * <p>
     * The timestamp when the data export configuration was created.
     * </p>
     * 
     * @return The timestamp when the data export configuration was created.
     */
    public final Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The status of the most recent export delivery.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #latestDeliveryStatus} will return {@link CapacityManagerDataExportStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #latestDeliveryStatusAsString}.
     * </p>
     * 
     * @return The status of the most recent export delivery.
     * @see CapacityManagerDataExportStatus
     */
    public final CapacityManagerDataExportStatus latestDeliveryStatus() {
        return CapacityManagerDataExportStatus.fromValue(latestDeliveryStatus);
    }

    /**
     * <p>
     * The status of the most recent export delivery.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #latestDeliveryStatus} will return {@link CapacityManagerDataExportStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #latestDeliveryStatusAsString}.
     * </p>
     * 
     * @return The status of the most recent export delivery.
     * @see CapacityManagerDataExportStatus
     */
    public final String latestDeliveryStatusAsString() {
        return latestDeliveryStatus;
    }

    /**
     * <p>
     * A message describing the status of the most recent export delivery, including any error details if the delivery
     * failed.
     * </p>
     * 
     * @return A message describing the status of the most recent export delivery, including any error details if the
     *         delivery failed.
     */
    public final String latestDeliveryStatusMessage() {
        return latestDeliveryStatusMessage;
    }

    /**
     * <p>
     * The S3 URI of the most recently delivered export file.
     * </p>
     * 
     * @return The S3 URI of the most recently delivered export file.
     */
    public final String latestDeliveryS3LocationUri() {
        return latestDeliveryS3LocationUri;
    }

    /**
     * <p>
     * The timestamp when the most recent export was delivered to S3.
     * </p>
     * 
     * @return The timestamp when the most recent export was delivered to S3.
     */
    public final Instant latestDeliveryTime() {
        return latestDeliveryTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags associated with the data export configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags associated with the data export configuration.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(capacityManagerDataExportId());
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(s3BucketPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleAsString());
        hashCode = 31 * hashCode + Objects.hashCode(outputFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createTime());
        hashCode = 31 * hashCode + Objects.hashCode(latestDeliveryStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(latestDeliveryStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(latestDeliveryS3LocationUri());
        hashCode = 31 * hashCode + Objects.hashCode(latestDeliveryTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CapacityManagerDataExportResponse)) {
            return false;
        }
        CapacityManagerDataExportResponse other = (CapacityManagerDataExportResponse) obj;
        return Objects.equals(capacityManagerDataExportId(), other.capacityManagerDataExportId())
                && Objects.equals(s3BucketName(), other.s3BucketName())
                && Objects.equals(s3BucketPrefix(), other.s3BucketPrefix())
                && Objects.equals(scheduleAsString(), other.scheduleAsString())
                && Objects.equals(outputFormatAsString(), other.outputFormatAsString())
                && Objects.equals(createTime(), other.createTime())
                && Objects.equals(latestDeliveryStatusAsString(), other.latestDeliveryStatusAsString())
                && Objects.equals(latestDeliveryStatusMessage(), other.latestDeliveryStatusMessage())
                && Objects.equals(latestDeliveryS3LocationUri(), other.latestDeliveryS3LocationUri())
                && Objects.equals(latestDeliveryTime(), other.latestDeliveryTime()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CapacityManagerDataExportResponse")
                .add("CapacityManagerDataExportId", capacityManagerDataExportId()).add("S3BucketName", s3BucketName())
                .add("S3BucketPrefix", s3BucketPrefix()).add("Schedule", scheduleAsString())
                .add("OutputFormat", outputFormatAsString()).add("CreateTime", createTime())
                .add("LatestDeliveryStatus", latestDeliveryStatusAsString())
                .add("LatestDeliveryStatusMessage", latestDeliveryStatusMessage())
                .add("LatestDeliveryS3LocationUri", latestDeliveryS3LocationUri())
                .add("LatestDeliveryTime", latestDeliveryTime()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CapacityManagerDataExportId":
            return Optional.ofNullable(clazz.cast(capacityManagerDataExportId()));
        case "S3BucketName":
            return Optional.ofNullable(clazz.cast(s3BucketName()));
        case "S3BucketPrefix":
            return Optional.ofNullable(clazz.cast(s3BucketPrefix()));
        case "Schedule":
            return Optional.ofNullable(clazz.cast(scheduleAsString()));
        case "OutputFormat":
            return Optional.ofNullable(clazz.cast(outputFormatAsString()));
        case "CreateTime":
            return Optional.ofNullable(clazz.cast(createTime()));
        case "LatestDeliveryStatus":
            return Optional.ofNullable(clazz.cast(latestDeliveryStatusAsString()));
        case "LatestDeliveryStatusMessage":
            return Optional.ofNullable(clazz.cast(latestDeliveryStatusMessage()));
        case "LatestDeliveryS3LocationUri":
            return Optional.ofNullable(clazz.cast(latestDeliveryS3LocationUri()));
        case "LatestDeliveryTime":
            return Optional.ofNullable(clazz.cast(latestDeliveryTime()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CapacityManagerDataExportId", CAPACITY_MANAGER_DATA_EXPORT_ID_FIELD);
        map.put("S3BucketName", S3_BUCKET_NAME_FIELD);
        map.put("S3BucketPrefix", S3_BUCKET_PREFIX_FIELD);
        map.put("Schedule", SCHEDULE_FIELD);
        map.put("OutputFormat", OUTPUT_FORMAT_FIELD);
        map.put("CreateTime", CREATE_TIME_FIELD);
        map.put("LatestDeliveryStatus", LATEST_DELIVERY_STATUS_FIELD);
        map.put("LatestDeliveryStatusMessage", LATEST_DELIVERY_STATUS_MESSAGE_FIELD);
        map.put("LatestDeliveryS3LocationUri", LATEST_DELIVERY_S3_LOCATION_URI_FIELD);
        map.put("LatestDeliveryTime", LATEST_DELIVERY_TIME_FIELD);
        map.put("TagSet", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CapacityManagerDataExportResponse, T> g) {
        return obj -> g.apply((CapacityManagerDataExportResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CapacityManagerDataExportResponse> {
        /**
         * <p>
         * The unique identifier for the data export configuration.
         * </p>
         * 
         * @param capacityManagerDataExportId
         *        The unique identifier for the data export configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityManagerDataExportId(String capacityManagerDataExportId);

        /**
         * <p>
         * The name of the S3 bucket where export files are delivered.
         * </p>
         * 
         * @param s3BucketName
         *        The name of the S3 bucket where export files are delivered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketName(String s3BucketName);

        /**
         * <p>
         * The S3 key prefix used for organizing export files within the bucket.
         * </p>
         * 
         * @param s3BucketPrefix
         *        The S3 key prefix used for organizing export files within the bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3BucketPrefix(String s3BucketPrefix);

        /**
         * <p>
         * The frequency at which data exports are generated.
         * </p>
         * 
         * @param schedule
         *        The frequency at which data exports are generated.
         * @see Schedule
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Schedule
         */
        Builder schedule(String schedule);

        /**
         * <p>
         * The frequency at which data exports are generated.
         * </p>
         * 
         * @param schedule
         *        The frequency at which data exports are generated.
         * @see Schedule
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Schedule
         */
        Builder schedule(Schedule schedule);

        /**
         * <p>
         * The file format of the exported data.
         * </p>
         * 
         * @param outputFormat
         *        The file format of the exported data.
         * @see OutputFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OutputFormat
         */
        Builder outputFormat(String outputFormat);

        /**
         * <p>
         * The file format of the exported data.
         * </p>
         * 
         * @param outputFormat
         *        The file format of the exported data.
         * @see OutputFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OutputFormat
         */
        Builder outputFormat(OutputFormat outputFormat);

        /**
         * <p>
         * The timestamp when the data export configuration was created.
         * </p>
         * 
         * @param createTime
         *        The timestamp when the data export configuration was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The status of the most recent export delivery.
         * </p>
         * 
         * @param latestDeliveryStatus
         *        The status of the most recent export delivery.
         * @see CapacityManagerDataExportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityManagerDataExportStatus
         */
        Builder latestDeliveryStatus(String latestDeliveryStatus);

        /**
         * <p>
         * The status of the most recent export delivery.
         * </p>
         * 
         * @param latestDeliveryStatus
         *        The status of the most recent export delivery.
         * @see CapacityManagerDataExportStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityManagerDataExportStatus
         */
        Builder latestDeliveryStatus(CapacityManagerDataExportStatus latestDeliveryStatus);

        /**
         * <p>
         * A message describing the status of the most recent export delivery, including any error details if the
         * delivery failed.
         * </p>
         * 
         * @param latestDeliveryStatusMessage
         *        A message describing the status of the most recent export delivery, including any error details if the
         *        delivery failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestDeliveryStatusMessage(String latestDeliveryStatusMessage);

        /**
         * <p>
         * The S3 URI of the most recently delivered export file.
         * </p>
         * 
         * @param latestDeliveryS3LocationUri
         *        The S3 URI of the most recently delivered export file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestDeliveryS3LocationUri(String latestDeliveryS3LocationUri);

        /**
         * <p>
         * The timestamp when the most recent export was delivered to S3.
         * </p>
         * 
         * @param latestDeliveryTime
         *        The timestamp when the most recent export was delivered to S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestDeliveryTime(Instant latestDeliveryTime);

        /**
         * <p>
         * The tags associated with the data export configuration.
         * </p>
         * 
         * @param tags
         *        The tags associated with the data export configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags associated with the data export configuration.
         * </p>
         * 
         * @param tags
         *        The tags associated with the data export configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags associated with the data export configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ec2.model.Tag.Builder} avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.ec2.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link software.amazon.awssdk.services.ec2.model.Tag.Builder#build()} is
         * called immediately and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link software.amazon.awssdk.services.ec2.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String capacityManagerDataExportId;

        private String s3BucketName;

        private String s3BucketPrefix;

        private String schedule;

        private String outputFormat;

        private Instant createTime;

        private String latestDeliveryStatus;

        private String latestDeliveryStatusMessage;

        private String latestDeliveryS3LocationUri;

        private Instant latestDeliveryTime;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CapacityManagerDataExportResponse model) {
            capacityManagerDataExportId(model.capacityManagerDataExportId);
            s3BucketName(model.s3BucketName);
            s3BucketPrefix(model.s3BucketPrefix);
            schedule(model.schedule);
            outputFormat(model.outputFormat);
            createTime(model.createTime);
            latestDeliveryStatus(model.latestDeliveryStatus);
            latestDeliveryStatusMessage(model.latestDeliveryStatusMessage);
            latestDeliveryS3LocationUri(model.latestDeliveryS3LocationUri);
            latestDeliveryTime(model.latestDeliveryTime);
            tags(model.tags);
        }

        public final String getCapacityManagerDataExportId() {
            return capacityManagerDataExportId;
        }

        public final void setCapacityManagerDataExportId(String capacityManagerDataExportId) {
            this.capacityManagerDataExportId = capacityManagerDataExportId;
        }

        @Override
        public final Builder capacityManagerDataExportId(String capacityManagerDataExportId) {
            this.capacityManagerDataExportId = capacityManagerDataExportId;
            return this;
        }

        public final String getS3BucketName() {
            return s3BucketName;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final String getS3BucketPrefix() {
            return s3BucketPrefix;
        }

        public final void setS3BucketPrefix(String s3BucketPrefix) {
            this.s3BucketPrefix = s3BucketPrefix;
        }

        @Override
        public final Builder s3BucketPrefix(String s3BucketPrefix) {
            this.s3BucketPrefix = s3BucketPrefix;
            return this;
        }

        public final String getSchedule() {
            return schedule;
        }

        public final void setSchedule(String schedule) {
            this.schedule = schedule;
        }

        @Override
        public final Builder schedule(String schedule) {
            this.schedule = schedule;
            return this;
        }

        @Override
        public final Builder schedule(Schedule schedule) {
            this.schedule(schedule == null ? null : schedule.toString());
            return this;
        }

        public final String getOutputFormat() {
            return outputFormat;
        }

        public final void setOutputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
        }

        @Override
        public final Builder outputFormat(String outputFormat) {
            this.outputFormat = outputFormat;
            return this;
        }

        @Override
        public final Builder outputFormat(OutputFormat outputFormat) {
            this.outputFormat(outputFormat == null ? null : outputFormat.toString());
            return this;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final String getLatestDeliveryStatus() {
            return latestDeliveryStatus;
        }

        public final void setLatestDeliveryStatus(String latestDeliveryStatus) {
            this.latestDeliveryStatus = latestDeliveryStatus;
        }

        @Override
        public final Builder latestDeliveryStatus(String latestDeliveryStatus) {
            this.latestDeliveryStatus = latestDeliveryStatus;
            return this;
        }

        @Override
        public final Builder latestDeliveryStatus(CapacityManagerDataExportStatus latestDeliveryStatus) {
            this.latestDeliveryStatus(latestDeliveryStatus == null ? null : latestDeliveryStatus.toString());
            return this;
        }

        public final String getLatestDeliveryStatusMessage() {
            return latestDeliveryStatusMessage;
        }

        public final void setLatestDeliveryStatusMessage(String latestDeliveryStatusMessage) {
            this.latestDeliveryStatusMessage = latestDeliveryStatusMessage;
        }

        @Override
        public final Builder latestDeliveryStatusMessage(String latestDeliveryStatusMessage) {
            this.latestDeliveryStatusMessage = latestDeliveryStatusMessage;
            return this;
        }

        public final String getLatestDeliveryS3LocationUri() {
            return latestDeliveryS3LocationUri;
        }

        public final void setLatestDeliveryS3LocationUri(String latestDeliveryS3LocationUri) {
            this.latestDeliveryS3LocationUri = latestDeliveryS3LocationUri;
        }

        @Override
        public final Builder latestDeliveryS3LocationUri(String latestDeliveryS3LocationUri) {
            this.latestDeliveryS3LocationUri = latestDeliveryS3LocationUri;
            return this;
        }

        public final Instant getLatestDeliveryTime() {
            return latestDeliveryTime;
        }

        public final void setLatestDeliveryTime(Instant latestDeliveryTime) {
            this.latestDeliveryTime = latestDeliveryTime;
        }

        @Override
        public final Builder latestDeliveryTime(Instant latestDeliveryTime) {
            this.latestDeliveryTime = latestDeliveryTime;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CapacityManagerDataExportResponse build() {
            return new CapacityManagerDataExportResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
