/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.FastLaunchLaunchTemplateSpecificationResponse;
import software.amazon.awssdk.services.ec2.model.FastLaunchResourceType;
import software.amazon.awssdk.services.ec2.model.FastLaunchSnapshotConfigurationResponse;
import software.amazon.awssdk.services.ec2.model.FastLaunchStateCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnableFastLaunchResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, EnableFastLaunchResponse> {
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageId").getter(EnableFastLaunchResponse.getter(EnableFastLaunchResponse::imageId)).setter(EnableFastLaunchResponse.setter(Builder::imageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").unmarshallLocationName("imageId").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(EnableFastLaunchResponse.getter(EnableFastLaunchResponse::resourceTypeAsString)).setter(EnableFastLaunchResponse.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").unmarshallLocationName("resourceType").build()}).build();
    private static final SdkField<FastLaunchSnapshotConfigurationResponse> SNAPSHOT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SnapshotConfiguration").getter(EnableFastLaunchResponse.getter(EnableFastLaunchResponse::snapshotConfiguration)).setter(EnableFastLaunchResponse.setter(Builder::snapshotConfiguration)).constructor(FastLaunchSnapshotConfigurationResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotConfiguration").unmarshallLocationName("snapshotConfiguration").build()}).build();
    private static final SdkField<FastLaunchLaunchTemplateSpecificationResponse> LAUNCH_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LaunchTemplate").getter(EnableFastLaunchResponse.getter(EnableFastLaunchResponse::launchTemplate)).setter(EnableFastLaunchResponse.setter(Builder::launchTemplate)).constructor(FastLaunchLaunchTemplateSpecificationResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplate").unmarshallLocationName("launchTemplate").build()}).build();
    private static final SdkField<Integer> MAX_PARALLEL_LAUNCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxParallelLaunches").getter(EnableFastLaunchResponse.getter(EnableFastLaunchResponse::maxParallelLaunches)).setter(EnableFastLaunchResponse.setter(Builder::maxParallelLaunches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxParallelLaunches").unmarshallLocationName("maxParallelLaunches").build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(EnableFastLaunchResponse.getter(EnableFastLaunchResponse::ownerId)).setter(EnableFastLaunchResponse.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").unmarshallLocationName("ownerId").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(EnableFastLaunchResponse.getter(EnableFastLaunchResponse::stateAsString)).setter(EnableFastLaunchResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").unmarshallLocationName("state").build()}).build();
    private static final SdkField<String> STATE_TRANSITION_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateTransitionReason").getter(EnableFastLaunchResponse.getter(EnableFastLaunchResponse::stateTransitionReason)).setter(EnableFastLaunchResponse.setter(Builder::stateTransitionReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateTransitionReason").unmarshallLocationName("stateTransitionReason").build()}).build();
    private static final SdkField<Instant> STATE_TRANSITION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StateTransitionTime").getter(EnableFastLaunchResponse.getter(EnableFastLaunchResponse::stateTransitionTime)).setter(EnableFastLaunchResponse.setter(Builder::stateTransitionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateTransitionTime").unmarshallLocationName("stateTransitionTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_ID_FIELD, RESOURCE_TYPE_FIELD, SNAPSHOT_CONFIGURATION_FIELD, LAUNCH_TEMPLATE_FIELD, MAX_PARALLEL_LAUNCHES_FIELD, OWNER_ID_FIELD, STATE_FIELD, STATE_TRANSITION_REASON_FIELD, STATE_TRANSITION_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EnableFastLaunchResponse.memberNameToFieldInitializer();
    private final String imageId;
    private final String resourceType;
    private final FastLaunchSnapshotConfigurationResponse snapshotConfiguration;
    private final FastLaunchLaunchTemplateSpecificationResponse launchTemplate;
    private final Integer maxParallelLaunches;
    private final String ownerId;
    private final String state;
    private final String stateTransitionReason;
    private final Instant stateTransitionTime;

    private EnableFastLaunchResponse(BuilderImpl builder) {
        super(builder);
        this.imageId = builder.imageId;
        this.resourceType = builder.resourceType;
        this.snapshotConfiguration = builder.snapshotConfiguration;
        this.launchTemplate = builder.launchTemplate;
        this.maxParallelLaunches = builder.maxParallelLaunches;
        this.ownerId = builder.ownerId;
        this.state = builder.state;
        this.stateTransitionReason = builder.stateTransitionReason;
        this.stateTransitionTime = builder.stateTransitionTime;
    }

    public final String imageId() {
        return this.imageId;
    }

    public final FastLaunchResourceType resourceType() {
        return FastLaunchResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final FastLaunchSnapshotConfigurationResponse snapshotConfiguration() {
        return this.snapshotConfiguration;
    }

    public final FastLaunchLaunchTemplateSpecificationResponse launchTemplate() {
        return this.launchTemplate;
    }

    public final Integer maxParallelLaunches() {
        return this.maxParallelLaunches;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final FastLaunchStateCode state() {
        return FastLaunchStateCode.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String stateTransitionReason() {
        return this.stateTransitionReason;
    }

    public final Instant stateTransitionTime() {
        return this.stateTransitionTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxParallelLaunches());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateTransitionReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateTransitionTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableFastLaunchResponse)) {
            return false;
        }
        EnableFastLaunchResponse other = (EnableFastLaunchResponse)((Object)obj);
        return Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.snapshotConfiguration(), other.snapshotConfiguration()) && Objects.equals(this.launchTemplate(), other.launchTemplate()) && Objects.equals(this.maxParallelLaunches(), other.maxParallelLaunches()) && Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.stateTransitionReason(), other.stateTransitionReason()) && Objects.equals(this.stateTransitionTime(), other.stateTransitionTime());
    }

    public final String toString() {
        return ToString.builder((String)"EnableFastLaunchResponse").add("ImageId", (Object)this.imageId()).add("ResourceType", (Object)this.resourceTypeAsString()).add("SnapshotConfiguration", (Object)this.snapshotConfiguration()).add("LaunchTemplate", (Object)this.launchTemplate()).add("MaxParallelLaunches", (Object)this.maxParallelLaunches()).add("OwnerId", (Object)this.ownerId()).add("State", (Object)this.stateAsString()).add("StateTransitionReason", (Object)this.stateTransitionReason()).add("StateTransitionTime", (Object)this.stateTransitionTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "SnapshotConfiguration": {
                return Optional.ofNullable(clazz.cast(this.snapshotConfiguration()));
            }
            case "LaunchTemplate": {
                return Optional.ofNullable(clazz.cast(this.launchTemplate()));
            }
            case "MaxParallelLaunches": {
                return Optional.ofNullable(clazz.cast(this.maxParallelLaunches()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StateTransitionReason": {
                return Optional.ofNullable(clazz.cast(this.stateTransitionReason()));
            }
            case "StateTransitionTime": {
                return Optional.ofNullable(clazz.cast(this.stateTransitionTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ImageId", IMAGE_ID_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("SnapshotConfiguration", SNAPSHOT_CONFIGURATION_FIELD);
        map.put("LaunchTemplate", LAUNCH_TEMPLATE_FIELD);
        map.put("MaxParallelLaunches", MAX_PARALLEL_LAUNCHES_FIELD);
        map.put("OwnerId", OWNER_ID_FIELD);
        map.put("State", STATE_FIELD);
        map.put("StateTransitionReason", STATE_TRANSITION_REASON_FIELD);
        map.put("StateTransitionTime", STATE_TRANSITION_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EnableFastLaunchResponse, T> g) {
        return obj -> g.apply((EnableFastLaunchResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private String imageId;
        private String resourceType;
        private FastLaunchSnapshotConfigurationResponse snapshotConfiguration;
        private FastLaunchLaunchTemplateSpecificationResponse launchTemplate;
        private Integer maxParallelLaunches;
        private String ownerId;
        private String state;
        private String stateTransitionReason;
        private Instant stateTransitionTime;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableFastLaunchResponse model) {
            super(model);
            this.imageId(model.imageId);
            this.resourceType(model.resourceType);
            this.snapshotConfiguration(model.snapshotConfiguration);
            this.launchTemplate(model.launchTemplate);
            this.maxParallelLaunches(model.maxParallelLaunches);
            this.ownerId(model.ownerId);
            this.state(model.state);
            this.stateTransitionReason(model.stateTransitionReason);
            this.stateTransitionTime(model.stateTransitionTime);
        }

        public final String getImageId() {
            return this.imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(FastLaunchResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final FastLaunchSnapshotConfigurationResponse.Builder getSnapshotConfiguration() {
            return this.snapshotConfiguration != null ? this.snapshotConfiguration.toBuilder() : null;
        }

        public final void setSnapshotConfiguration(FastLaunchSnapshotConfigurationResponse.BuilderImpl snapshotConfiguration) {
            this.snapshotConfiguration = snapshotConfiguration != null ? snapshotConfiguration.build() : null;
        }

        @Override
        public final Builder snapshotConfiguration(FastLaunchSnapshotConfigurationResponse snapshotConfiguration) {
            this.snapshotConfiguration = snapshotConfiguration;
            return this;
        }

        public final FastLaunchLaunchTemplateSpecificationResponse.Builder getLaunchTemplate() {
            return this.launchTemplate != null ? this.launchTemplate.toBuilder() : null;
        }

        public final void setLaunchTemplate(FastLaunchLaunchTemplateSpecificationResponse.BuilderImpl launchTemplate) {
            this.launchTemplate = launchTemplate != null ? launchTemplate.build() : null;
        }

        @Override
        public final Builder launchTemplate(FastLaunchLaunchTemplateSpecificationResponse launchTemplate) {
            this.launchTemplate = launchTemplate;
            return this;
        }

        public final Integer getMaxParallelLaunches() {
            return this.maxParallelLaunches;
        }

        public final void setMaxParallelLaunches(Integer maxParallelLaunches) {
            this.maxParallelLaunches = maxParallelLaunches;
        }

        @Override
        public final Builder maxParallelLaunches(Integer maxParallelLaunches) {
            this.maxParallelLaunches = maxParallelLaunches;
            return this;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(FastLaunchStateCode state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStateTransitionReason() {
            return this.stateTransitionReason;
        }

        public final void setStateTransitionReason(String stateTransitionReason) {
            this.stateTransitionReason = stateTransitionReason;
        }

        @Override
        public final Builder stateTransitionReason(String stateTransitionReason) {
            this.stateTransitionReason = stateTransitionReason;
            return this;
        }

        public final Instant getStateTransitionTime() {
            return this.stateTransitionTime;
        }

        public final void setStateTransitionTime(Instant stateTransitionTime) {
            this.stateTransitionTime = stateTransitionTime;
        }

        @Override
        public final Builder stateTransitionTime(Instant stateTransitionTime) {
            this.stateTransitionTime = stateTransitionTime;
            return this;
        }

        @Override
        public EnableFastLaunchResponse build() {
            return new EnableFastLaunchResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, EnableFastLaunchResponse> {
        public Builder imageId(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(FastLaunchResourceType var1);

        public Builder snapshotConfiguration(FastLaunchSnapshotConfigurationResponse var1);

        default public Builder snapshotConfiguration(Consumer<FastLaunchSnapshotConfigurationResponse.Builder> snapshotConfiguration) {
            return this.snapshotConfiguration((FastLaunchSnapshotConfigurationResponse)((FastLaunchSnapshotConfigurationResponse.Builder)FastLaunchSnapshotConfigurationResponse.builder().applyMutation(snapshotConfiguration)).build());
        }

        public Builder launchTemplate(FastLaunchLaunchTemplateSpecificationResponse var1);

        default public Builder launchTemplate(Consumer<FastLaunchLaunchTemplateSpecificationResponse.Builder> launchTemplate) {
            return this.launchTemplate((FastLaunchLaunchTemplateSpecificationResponse)((FastLaunchLaunchTemplateSpecificationResponse.Builder)FastLaunchLaunchTemplateSpecificationResponse.builder().applyMutation(launchTemplate)).build());
        }

        public Builder maxParallelLaunches(Integer var1);

        public Builder ownerId(String var1);

        public Builder state(String var1);

        public Builder state(FastLaunchStateCode var1);

        public Builder stateTransitionReason(String var1);

        public Builder stateTransitionTime(Instant var1);
    }
}

