/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.SnapshotInfo;
import software.amazon.awssdk.services.ec2.model.SnapshotSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSnapshotsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, CreateSnapshotsResponse> {
    private static final SdkField<List<SnapshotInfo>> SNAPSHOTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Snapshots").getter(CreateSnapshotsResponse.getter(CreateSnapshotsResponse::snapshots)).setter(CreateSnapshotsResponse.setter(Builder::snapshots)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotSet").unmarshallLocationName("snapshotSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SnapshotInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateSnapshotsResponse.memberNameToFieldInitializer();
    private final List<SnapshotInfo> snapshots;

    private CreateSnapshotsResponse(BuilderImpl builder) {
        super(builder);
        this.snapshots = builder.snapshots;
    }

    public final boolean hasSnapshots() {
        return this.snapshots != null && !(this.snapshots instanceof SdkAutoConstructList);
    }

    public final List<SnapshotInfo> snapshots() {
        return this.snapshots;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSnapshots() ? this.snapshots() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSnapshotsResponse)) {
            return false;
        }
        CreateSnapshotsResponse other = (CreateSnapshotsResponse)((Object)obj);
        return this.hasSnapshots() == other.hasSnapshots() && Objects.equals(this.snapshots(), other.snapshots());
    }

    public final String toString() {
        return ToString.builder((String)"CreateSnapshotsResponse").add("Snapshots", this.hasSnapshots() ? this.snapshots() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Snapshots": {
                return Optional.ofNullable(clazz.cast(this.snapshots()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<SnapshotInfo>>> map = new HashMap<String, SdkField<List<SnapshotInfo>>>();
        map.put("SnapshotSet", SNAPSHOTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateSnapshotsResponse, T> g) {
        return obj -> g.apply((CreateSnapshotsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<SnapshotInfo> snapshots = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSnapshotsResponse model) {
            super(model);
            this.snapshots(model.snapshots);
        }

        public final List<SnapshotInfo.Builder> getSnapshots() {
            List<SnapshotInfo.Builder> result = SnapshotSetCopier.copyToBuilder(this.snapshots);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSnapshots(Collection<SnapshotInfo.BuilderImpl> snapshots) {
            this.snapshots = SnapshotSetCopier.copyFromBuilder(snapshots);
        }

        @Override
        public final Builder snapshots(Collection<SnapshotInfo> snapshots) {
            this.snapshots = SnapshotSetCopier.copy(snapshots);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshots(SnapshotInfo ... snapshots) {
            this.snapshots(Arrays.asList(snapshots));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshots(Consumer<SnapshotInfo.Builder> ... snapshots) {
            this.snapshots(Stream.of(snapshots).map(c -> (SnapshotInfo)((SnapshotInfo.Builder)SnapshotInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CreateSnapshotsResponse build() {
            return new CreateSnapshotsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSnapshotsResponse> {
        public Builder snapshots(Collection<SnapshotInfo> var1);

        public Builder snapshots(SnapshotInfo ... var1);

        public Builder snapshots(Consumer<SnapshotInfo.Builder> ... var1);
    }
}

