/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.DiskInfo;
import software.amazon.awssdk.services.ec2.model.DiskInfoListCopier;
import software.amazon.awssdk.services.ec2.model.EphemeralNvmeSupport;
import software.amazon.awssdk.services.ec2.model.InstanceStorageEncryptionSupport;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceStorageInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceStorageInfo> {
    private static final SdkField<Long> TOTAL_SIZE_IN_GB_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TotalSizeInGB").getter(InstanceStorageInfo.getter(InstanceStorageInfo::totalSizeInGB)).setter(InstanceStorageInfo.setter(Builder::totalSizeInGB)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalSizeInGB").unmarshallLocationName("totalSizeInGB").build()}).build();
    private static final SdkField<List<DiskInfo>> DISKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Disks").getter(InstanceStorageInfo.getter(InstanceStorageInfo::disks)).setter(InstanceStorageInfo.setter(Builder::disks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Disks").unmarshallLocationName("disks").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DiskInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NVME_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NvmeSupport").getter(InstanceStorageInfo.getter(InstanceStorageInfo::nvmeSupportAsString)).setter(InstanceStorageInfo.setter(Builder::nvmeSupport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NvmeSupport").unmarshallLocationName("nvmeSupport").build()}).build();
    private static final SdkField<String> ENCRYPTION_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionSupport").getter(InstanceStorageInfo.getter(InstanceStorageInfo::encryptionSupportAsString)).setter(InstanceStorageInfo.setter(Builder::encryptionSupport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionSupport").unmarshallLocationName("encryptionSupport").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_SIZE_IN_GB_FIELD, DISKS_FIELD, NVME_SUPPORT_FIELD, ENCRYPTION_SUPPORT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InstanceStorageInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Long totalSizeInGB;
    private final List<DiskInfo> disks;
    private final String nvmeSupport;
    private final String encryptionSupport;

    private InstanceStorageInfo(BuilderImpl builder) {
        this.totalSizeInGB = builder.totalSizeInGB;
        this.disks = builder.disks;
        this.nvmeSupport = builder.nvmeSupport;
        this.encryptionSupport = builder.encryptionSupport;
    }

    public final Long totalSizeInGB() {
        return this.totalSizeInGB;
    }

    public final boolean hasDisks() {
        return this.disks != null && !(this.disks instanceof SdkAutoConstructList);
    }

    public final List<DiskInfo> disks() {
        return this.disks;
    }

    public final EphemeralNvmeSupport nvmeSupport() {
        return EphemeralNvmeSupport.fromValue(this.nvmeSupport);
    }

    public final String nvmeSupportAsString() {
        return this.nvmeSupport;
    }

    public final InstanceStorageEncryptionSupport encryptionSupport() {
        return InstanceStorageEncryptionSupport.fromValue(this.encryptionSupport);
    }

    public final String encryptionSupportAsString() {
        return this.encryptionSupport;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.totalSizeInGB());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDisks() ? this.disks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nvmeSupportAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionSupportAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceStorageInfo)) {
            return false;
        }
        InstanceStorageInfo other = (InstanceStorageInfo)obj;
        return Objects.equals(this.totalSizeInGB(), other.totalSizeInGB()) && this.hasDisks() == other.hasDisks() && Objects.equals(this.disks(), other.disks()) && Objects.equals(this.nvmeSupportAsString(), other.nvmeSupportAsString()) && Objects.equals(this.encryptionSupportAsString(), other.encryptionSupportAsString());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceStorageInfo").add("TotalSizeInGB", (Object)this.totalSizeInGB()).add("Disks", this.hasDisks() ? this.disks() : null).add("NvmeSupport", (Object)this.nvmeSupportAsString()).add("EncryptionSupport", (Object)this.encryptionSupportAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TotalSizeInGB": {
                return Optional.ofNullable(clazz.cast(this.totalSizeInGB()));
            }
            case "Disks": {
                return Optional.ofNullable(clazz.cast(this.disks()));
            }
            case "NvmeSupport": {
                return Optional.ofNullable(clazz.cast(this.nvmeSupportAsString()));
            }
            case "EncryptionSupport": {
                return Optional.ofNullable(clazz.cast(this.encryptionSupportAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TotalSizeInGB", TOTAL_SIZE_IN_GB_FIELD);
        map.put("Disks", DISKS_FIELD);
        map.put("NvmeSupport", NVME_SUPPORT_FIELD);
        map.put("EncryptionSupport", ENCRYPTION_SUPPORT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceStorageInfo, T> g) {
        return obj -> g.apply((InstanceStorageInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long totalSizeInGB;
        private List<DiskInfo> disks = DefaultSdkAutoConstructList.getInstance();
        private String nvmeSupport;
        private String encryptionSupport;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceStorageInfo model) {
            this.totalSizeInGB(model.totalSizeInGB);
            this.disks(model.disks);
            this.nvmeSupport(model.nvmeSupport);
            this.encryptionSupport(model.encryptionSupport);
        }

        public final Long getTotalSizeInGB() {
            return this.totalSizeInGB;
        }

        public final void setTotalSizeInGB(Long totalSizeInGB) {
            this.totalSizeInGB = totalSizeInGB;
        }

        @Override
        public final Builder totalSizeInGB(Long totalSizeInGB) {
            this.totalSizeInGB = totalSizeInGB;
            return this;
        }

        public final List<DiskInfo.Builder> getDisks() {
            List<DiskInfo.Builder> result = DiskInfoListCopier.copyToBuilder(this.disks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDisks(Collection<DiskInfo.BuilderImpl> disks) {
            this.disks = DiskInfoListCopier.copyFromBuilder(disks);
        }

        @Override
        public final Builder disks(Collection<DiskInfo> disks) {
            this.disks = DiskInfoListCopier.copy(disks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder disks(DiskInfo ... disks) {
            this.disks(Arrays.asList(disks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder disks(Consumer<DiskInfo.Builder> ... disks) {
            this.disks(Stream.of(disks).map(c -> (DiskInfo)((DiskInfo.Builder)DiskInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNvmeSupport() {
            return this.nvmeSupport;
        }

        public final void setNvmeSupport(String nvmeSupport) {
            this.nvmeSupport = nvmeSupport;
        }

        @Override
        public final Builder nvmeSupport(String nvmeSupport) {
            this.nvmeSupport = nvmeSupport;
            return this;
        }

        @Override
        public final Builder nvmeSupport(EphemeralNvmeSupport nvmeSupport) {
            this.nvmeSupport(nvmeSupport == null ? null : nvmeSupport.toString());
            return this;
        }

        public final String getEncryptionSupport() {
            return this.encryptionSupport;
        }

        public final void setEncryptionSupport(String encryptionSupport) {
            this.encryptionSupport = encryptionSupport;
        }

        @Override
        public final Builder encryptionSupport(String encryptionSupport) {
            this.encryptionSupport = encryptionSupport;
            return this;
        }

        @Override
        public final Builder encryptionSupport(InstanceStorageEncryptionSupport encryptionSupport) {
            this.encryptionSupport(encryptionSupport == null ? null : encryptionSupport.toString());
            return this;
        }

        public InstanceStorageInfo build() {
            return new InstanceStorageInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceStorageInfo> {
        public Builder totalSizeInGB(Long var1);

        public Builder disks(Collection<DiskInfo> var1);

        public Builder disks(DiskInfo ... var1);

        public Builder disks(Consumer<DiskInfo.Builder> ... var1);

        public Builder nvmeSupport(String var1);

        public Builder nvmeSupport(EphemeralNvmeSupport var1);

        public Builder encryptionSupport(String var1);

        public Builder encryptionSupport(InstanceStorageEncryptionSupport var1);
    }
}

