/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the GPU accelerators for the instance type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GpuDeviceInfo implements SdkPojo, Serializable, ToCopyableBuilder<GpuDeviceInfo.Builder, GpuDeviceInfo> {
    private static final SdkField<String> NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Name")
            .getter(getter(GpuDeviceInfo::name))
            .setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name")
                    .unmarshallLocationName("name").build()).build();

    private static final SdkField<String> MANUFACTURER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Manufacturer")
            .getter(getter(GpuDeviceInfo::manufacturer))
            .setter(setter(Builder::manufacturer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Manufacturer")
                    .unmarshallLocationName("manufacturer").build()).build();

    private static final SdkField<Integer> COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Count")
            .getter(getter(GpuDeviceInfo::count))
            .setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Count")
                    .unmarshallLocationName("count").build()).build();

    private static final SdkField<GpuDeviceMemoryInfo> MEMORY_INFO_FIELD = SdkField
            .<GpuDeviceMemoryInfo> builder(MarshallingType.SDK_POJO)
            .memberName("MemoryInfo")
            .getter(getter(GpuDeviceInfo::memoryInfo))
            .setter(setter(Builder::memoryInfo))
            .constructor(GpuDeviceMemoryInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemoryInfo")
                    .unmarshallLocationName("memoryInfo").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            MANUFACTURER_FIELD, COUNT_FIELD, MEMORY_INFO_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String manufacturer;

    private final Integer count;

    private final GpuDeviceMemoryInfo memoryInfo;

    private GpuDeviceInfo(BuilderImpl builder) {
        this.name = builder.name;
        this.manufacturer = builder.manufacturer;
        this.count = builder.count;
        this.memoryInfo = builder.memoryInfo;
    }

    /**
     * <p>
     * The name of the GPU accelerator.
     * </p>
     * 
     * @return The name of the GPU accelerator.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The manufacturer of the GPU accelerator.
     * </p>
     * 
     * @return The manufacturer of the GPU accelerator.
     */
    public final String manufacturer() {
        return manufacturer;
    }

    /**
     * <p>
     * The number of GPUs for the instance type.
     * </p>
     * 
     * @return The number of GPUs for the instance type.
     */
    public final Integer count() {
        return count;
    }

    /**
     * <p>
     * Describes the memory available to the GPU accelerator.
     * </p>
     * 
     * @return Describes the memory available to the GPU accelerator.
     */
    public final GpuDeviceMemoryInfo memoryInfo() {
        return memoryInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(manufacturer());
        hashCode = 31 * hashCode + Objects.hashCode(count());
        hashCode = 31 * hashCode + Objects.hashCode(memoryInfo());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GpuDeviceInfo)) {
            return false;
        }
        GpuDeviceInfo other = (GpuDeviceInfo) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(manufacturer(), other.manufacturer())
                && Objects.equals(count(), other.count()) && Objects.equals(memoryInfo(), other.memoryInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GpuDeviceInfo").add("Name", name()).add("Manufacturer", manufacturer()).add("Count", count())
                .add("MemoryInfo", memoryInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Manufacturer":
            return Optional.ofNullable(clazz.cast(manufacturer()));
        case "Count":
            return Optional.ofNullable(clazz.cast(count()));
        case "MemoryInfo":
            return Optional.ofNullable(clazz.cast(memoryInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Manufacturer", MANUFACTURER_FIELD);
        map.put("Count", COUNT_FIELD);
        map.put("MemoryInfo", MEMORY_INFO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GpuDeviceInfo, T> g) {
        return obj -> g.apply((GpuDeviceInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GpuDeviceInfo> {
        /**
         * <p>
         * The name of the GPU accelerator.
         * </p>
         * 
         * @param name
         *        The name of the GPU accelerator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The manufacturer of the GPU accelerator.
         * </p>
         * 
         * @param manufacturer
         *        The manufacturer of the GPU accelerator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manufacturer(String manufacturer);

        /**
         * <p>
         * The number of GPUs for the instance type.
         * </p>
         * 
         * @param count
         *        The number of GPUs for the instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Integer count);

        /**
         * <p>
         * Describes the memory available to the GPU accelerator.
         * </p>
         * 
         * @param memoryInfo
         *        Describes the memory available to the GPU accelerator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memoryInfo(GpuDeviceMemoryInfo memoryInfo);

        /**
         * <p>
         * Describes the memory available to the GPU accelerator.
         * </p>
         * This is a convenience method that creates an instance of the {@link GpuDeviceMemoryInfo.Builder} avoiding the
         * need to create one manually via {@link GpuDeviceMemoryInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GpuDeviceMemoryInfo.Builder#build()} is called immediately and
         * its result is passed to {@link #memoryInfo(GpuDeviceMemoryInfo)}.
         * 
         * @param memoryInfo
         *        a consumer that will call methods on {@link GpuDeviceMemoryInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #memoryInfo(GpuDeviceMemoryInfo)
         */
        default Builder memoryInfo(Consumer<GpuDeviceMemoryInfo.Builder> memoryInfo) {
            return memoryInfo(GpuDeviceMemoryInfo.builder().applyMutation(memoryInfo).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String manufacturer;

        private Integer count;

        private GpuDeviceMemoryInfo memoryInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(GpuDeviceInfo model) {
            name(model.name);
            manufacturer(model.manufacturer);
            count(model.count);
            memoryInfo(model.memoryInfo);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getManufacturer() {
            return manufacturer;
        }

        public final void setManufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
        }

        @Override
        public final Builder manufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
            return this;
        }

        public final Integer getCount() {
            return count;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final GpuDeviceMemoryInfo.Builder getMemoryInfo() {
            return memoryInfo != null ? memoryInfo.toBuilder() : null;
        }

        public final void setMemoryInfo(GpuDeviceMemoryInfo.BuilderImpl memoryInfo) {
            this.memoryInfo = memoryInfo != null ? memoryInfo.build() : null;
        }

        @Override
        public final Builder memoryInfo(GpuDeviceMemoryInfo memoryInfo) {
            this.memoryInfo = memoryInfo;
            return this;
        }

        @Override
        public GpuDeviceInfo build() {
            return new GpuDeviceInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
