/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a Capacity Reservation in a Capacity Reservation Fleet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FleetCapacityReservation implements SdkPojo, Serializable,
        ToCopyableBuilder<FleetCapacityReservation.Builder, FleetCapacityReservation> {
    private static final SdkField<String> CAPACITY_RESERVATION_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CapacityReservationId")
            .getter(getter(FleetCapacityReservation::capacityReservationId))
            .setter(setter(Builder::capacityReservationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityReservationId")
                    .unmarshallLocationName("capacityReservationId").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZoneId")
            .getter(getter(FleetCapacityReservation::availabilityZoneId))
            .setter(setter(Builder::availabilityZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneId")
                    .unmarshallLocationName("availabilityZoneId").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstanceType")
            .getter(getter(FleetCapacityReservation::instanceTypeAsString))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType")
                    .unmarshallLocationName("instanceType").build()).build();

    private static final SdkField<String> INSTANCE_PLATFORM_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("InstancePlatform")
            .getter(getter(FleetCapacityReservation::instancePlatformAsString))
            .setter(setter(Builder::instancePlatform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstancePlatform")
                    .unmarshallLocationName("instancePlatform").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone")
            .getter(getter(FleetCapacityReservation::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone")
                    .unmarshallLocationName("availabilityZone").build()).build();

    private static final SdkField<Integer> TOTAL_INSTANCE_COUNT_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalInstanceCount")
            .getter(getter(FleetCapacityReservation::totalInstanceCount))
            .setter(setter(Builder::totalInstanceCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalInstanceCount")
                    .unmarshallLocationName("totalInstanceCount").build()).build();

    private static final SdkField<Double> FULFILLED_CAPACITY_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("FulfilledCapacity")
            .getter(getter(FleetCapacityReservation::fulfilledCapacity))
            .setter(setter(Builder::fulfilledCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FulfilledCapacity")
                    .unmarshallLocationName("fulfilledCapacity").build()).build();

    private static final SdkField<Boolean> EBS_OPTIMIZED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EbsOptimized")
            .getter(getter(FleetCapacityReservation::ebsOptimized))
            .setter(setter(Builder::ebsOptimized))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EbsOptimized")
                    .unmarshallLocationName("ebsOptimized").build()).build();

    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateDate")
            .getter(getter(FleetCapacityReservation::createDate))
            .setter(setter(Builder::createDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate")
                    .unmarshallLocationName("createDate").build()).build();

    private static final SdkField<Double> WEIGHT_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("Weight")
            .getter(getter(FleetCapacityReservation::weight))
            .setter(setter(Builder::weight))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Weight")
                    .unmarshallLocationName("weight").build()).build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Priority")
            .getter(getter(FleetCapacityReservation::priority))
            .setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority")
                    .unmarshallLocationName("priority").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_RESERVATION_ID_FIELD,
            AVAILABILITY_ZONE_ID_FIELD, INSTANCE_TYPE_FIELD, INSTANCE_PLATFORM_FIELD, AVAILABILITY_ZONE_FIELD,
            TOTAL_INSTANCE_COUNT_FIELD, FULFILLED_CAPACITY_FIELD, EBS_OPTIMIZED_FIELD, CREATE_DATE_FIELD, WEIGHT_FIELD,
            PRIORITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String capacityReservationId;

    private final String availabilityZoneId;

    private final String instanceType;

    private final String instancePlatform;

    private final String availabilityZone;

    private final Integer totalInstanceCount;

    private final Double fulfilledCapacity;

    private final Boolean ebsOptimized;

    private final Instant createDate;

    private final Double weight;

    private final Integer priority;

    private FleetCapacityReservation(BuilderImpl builder) {
        this.capacityReservationId = builder.capacityReservationId;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.instanceType = builder.instanceType;
        this.instancePlatform = builder.instancePlatform;
        this.availabilityZone = builder.availabilityZone;
        this.totalInstanceCount = builder.totalInstanceCount;
        this.fulfilledCapacity = builder.fulfilledCapacity;
        this.ebsOptimized = builder.ebsOptimized;
        this.createDate = builder.createDate;
        this.weight = builder.weight;
        this.priority = builder.priority;
    }

    /**
     * <p>
     * The ID of the Capacity Reservation.
     * </p>
     * 
     * @return The ID of the Capacity Reservation.
     */
    public final String capacityReservationId() {
        return capacityReservationId;
    }

    /**
     * <p>
     * The ID of the Availability Zone in which the Capacity Reservation reserves capacity.
     * </p>
     * 
     * @return The ID of the Availability Zone in which the Capacity Reservation reserves capacity.
     */
    public final String availabilityZoneId() {
        return availabilityZoneId;
    }

    /**
     * <p>
     * The instance type for which the Capacity Reservation reserves capacity.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance type for which the Capacity Reservation reserves capacity.
     * @see InstanceType
     */
    public final InstanceType instanceType() {
        return InstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The instance type for which the Capacity Reservation reserves capacity.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link InstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance type for which the Capacity Reservation reserves capacity.
     * @see InstanceType
     */
    public final String instanceTypeAsString() {
        return instanceType;
    }

    /**
     * <p>
     * The type of operating system for which the Capacity Reservation reserves capacity.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instancePlatform}
     * will return {@link CapacityReservationInstancePlatform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #instancePlatformAsString}.
     * </p>
     * 
     * @return The type of operating system for which the Capacity Reservation reserves capacity.
     * @see CapacityReservationInstancePlatform
     */
    public final CapacityReservationInstancePlatform instancePlatform() {
        return CapacityReservationInstancePlatform.fromValue(instancePlatform);
    }

    /**
     * <p>
     * The type of operating system for which the Capacity Reservation reserves capacity.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instancePlatform}
     * will return {@link CapacityReservationInstancePlatform#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #instancePlatformAsString}.
     * </p>
     * 
     * @return The type of operating system for which the Capacity Reservation reserves capacity.
     * @see CapacityReservationInstancePlatform
     */
    public final String instancePlatformAsString() {
        return instancePlatform;
    }

    /**
     * <p>
     * The Availability Zone in which the Capacity Reservation reserves capacity.
     * </p>
     * 
     * @return The Availability Zone in which the Capacity Reservation reserves capacity.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The total number of instances for which the Capacity Reservation reserves capacity.
     * </p>
     * 
     * @return The total number of instances for which the Capacity Reservation reserves capacity.
     */
    public final Integer totalInstanceCount() {
        return totalInstanceCount;
    }

    /**
     * <p>
     * The number of capacity units fulfilled by the Capacity Reservation. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#target-capacity">Total target
     * capacity</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @return The number of capacity units fulfilled by the Capacity Reservation. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#target-capacity">Total
     *         target capacity</a> in the <i>Amazon EC2 User Guide</i>.
     */
    public final Double fulfilledCapacity() {
        return fulfilledCapacity;
    }

    /**
     * <p>
     * Indicates whether the Capacity Reservation reserves capacity for EBS-optimized instance types.
     * </p>
     * 
     * @return Indicates whether the Capacity Reservation reserves capacity for EBS-optimized instance types.
     */
    public final Boolean ebsOptimized() {
        return ebsOptimized;
    }

    /**
     * <p>
     * The date and time at which the Capacity Reservation was created.
     * </p>
     * 
     * @return The date and time at which the Capacity Reservation was created.
     */
    public final Instant createDate() {
        return createDate;
    }

    /**
     * <p>
     * The weight of the instance type in the Capacity Reservation Fleet. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#instance-weight">Instance type
     * weight</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @return The weight of the instance type in the Capacity Reservation Fleet. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#instance-weight">Instance
     *         type weight</a> in the <i>Amazon EC2 User Guide</i>.
     */
    public final Double weight() {
        return weight;
    }

    /**
     * <p>
     * The priority of the instance type in the Capacity Reservation Fleet. For more information, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#instance-priority">Instance type
     * priority</a> in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * 
     * @return The priority of the instance type in the Capacity Reservation Fleet. For more information, see <a
     *         href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#instance-priority"
     *         >Instance type priority</a> in the <i>Amazon EC2 User Guide</i>.
     */
    public final Integer priority() {
        return priority;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(capacityReservationId());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(instancePlatformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(totalInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(fulfilledCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(ebsOptimized());
        hashCode = 31 * hashCode + Objects.hashCode(createDate());
        hashCode = 31 * hashCode + Objects.hashCode(weight());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FleetCapacityReservation)) {
            return false;
        }
        FleetCapacityReservation other = (FleetCapacityReservation) obj;
        return Objects.equals(capacityReservationId(), other.capacityReservationId())
                && Objects.equals(availabilityZoneId(), other.availabilityZoneId())
                && Objects.equals(instanceTypeAsString(), other.instanceTypeAsString())
                && Objects.equals(instancePlatformAsString(), other.instancePlatformAsString())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(totalInstanceCount(), other.totalInstanceCount())
                && Objects.equals(fulfilledCapacity(), other.fulfilledCapacity())
                && Objects.equals(ebsOptimized(), other.ebsOptimized()) && Objects.equals(createDate(), other.createDate())
                && Objects.equals(weight(), other.weight()) && Objects.equals(priority(), other.priority());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FleetCapacityReservation").add("CapacityReservationId", capacityReservationId())
                .add("AvailabilityZoneId", availabilityZoneId()).add("InstanceType", instanceTypeAsString())
                .add("InstancePlatform", instancePlatformAsString()).add("AvailabilityZone", availabilityZone())
                .add("TotalInstanceCount", totalInstanceCount()).add("FulfilledCapacity", fulfilledCapacity())
                .add("EbsOptimized", ebsOptimized()).add("CreateDate", createDate()).add("Weight", weight())
                .add("Priority", priority()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CapacityReservationId":
            return Optional.ofNullable(clazz.cast(capacityReservationId()));
        case "AvailabilityZoneId":
            return Optional.ofNullable(clazz.cast(availabilityZoneId()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        case "InstancePlatform":
            return Optional.ofNullable(clazz.cast(instancePlatformAsString()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "TotalInstanceCount":
            return Optional.ofNullable(clazz.cast(totalInstanceCount()));
        case "FulfilledCapacity":
            return Optional.ofNullable(clazz.cast(fulfilledCapacity()));
        case "EbsOptimized":
            return Optional.ofNullable(clazz.cast(ebsOptimized()));
        case "CreateDate":
            return Optional.ofNullable(clazz.cast(createDate()));
        case "Weight":
            return Optional.ofNullable(clazz.cast(weight()));
        case "Priority":
            return Optional.ofNullable(clazz.cast(priority()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CapacityReservationId", CAPACITY_RESERVATION_ID_FIELD);
        map.put("AvailabilityZoneId", AVAILABILITY_ZONE_ID_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("InstancePlatform", INSTANCE_PLATFORM_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("TotalInstanceCount", TOTAL_INSTANCE_COUNT_FIELD);
        map.put("FulfilledCapacity", FULFILLED_CAPACITY_FIELD);
        map.put("EbsOptimized", EBS_OPTIMIZED_FIELD);
        map.put("CreateDate", CREATE_DATE_FIELD);
        map.put("Weight", WEIGHT_FIELD);
        map.put("Priority", PRIORITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FleetCapacityReservation, T> g) {
        return obj -> g.apply((FleetCapacityReservation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FleetCapacityReservation> {
        /**
         * <p>
         * The ID of the Capacity Reservation.
         * </p>
         * 
         * @param capacityReservationId
         *        The ID of the Capacity Reservation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityReservationId(String capacityReservationId);

        /**
         * <p>
         * The ID of the Availability Zone in which the Capacity Reservation reserves capacity.
         * </p>
         * 
         * @param availabilityZoneId
         *        The ID of the Availability Zone in which the Capacity Reservation reserves capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZoneId(String availabilityZoneId);

        /**
         * <p>
         * The instance type for which the Capacity Reservation reserves capacity.
         * </p>
         * 
         * @param instanceType
         *        The instance type for which the Capacity Reservation reserves capacity.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The instance type for which the Capacity Reservation reserves capacity.
         * </p>
         * 
         * @param instanceType
         *        The instance type for which the Capacity Reservation reserves capacity.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(InstanceType instanceType);

        /**
         * <p>
         * The type of operating system for which the Capacity Reservation reserves capacity.
         * </p>
         * 
         * @param instancePlatform
         *        The type of operating system for which the Capacity Reservation reserves capacity.
         * @see CapacityReservationInstancePlatform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityReservationInstancePlatform
         */
        Builder instancePlatform(String instancePlatform);

        /**
         * <p>
         * The type of operating system for which the Capacity Reservation reserves capacity.
         * </p>
         * 
         * @param instancePlatform
         *        The type of operating system for which the Capacity Reservation reserves capacity.
         * @see CapacityReservationInstancePlatform
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CapacityReservationInstancePlatform
         */
        Builder instancePlatform(CapacityReservationInstancePlatform instancePlatform);

        /**
         * <p>
         * The Availability Zone in which the Capacity Reservation reserves capacity.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone in which the Capacity Reservation reserves capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The total number of instances for which the Capacity Reservation reserves capacity.
         * </p>
         * 
         * @param totalInstanceCount
         *        The total number of instances for which the Capacity Reservation reserves capacity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalInstanceCount(Integer totalInstanceCount);

        /**
         * <p>
         * The number of capacity units fulfilled by the Capacity Reservation. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#target-capacity">Total target
         * capacity</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * 
         * @param fulfilledCapacity
         *        The number of capacity units fulfilled by the Capacity Reservation. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#target-capacity">Total
         *        target capacity</a> in the <i>Amazon EC2 User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fulfilledCapacity(Double fulfilledCapacity);

        /**
         * <p>
         * Indicates whether the Capacity Reservation reserves capacity for EBS-optimized instance types.
         * </p>
         * 
         * @param ebsOptimized
         *        Indicates whether the Capacity Reservation reserves capacity for EBS-optimized instance types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsOptimized(Boolean ebsOptimized);

        /**
         * <p>
         * The date and time at which the Capacity Reservation was created.
         * </p>
         * 
         * @param createDate
         *        The date and time at which the Capacity Reservation was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDate(Instant createDate);

        /**
         * <p>
         * The weight of the instance type in the Capacity Reservation Fleet. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#instance-weight">Instance
         * type weight</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * 
         * @param weight
         *        The weight of the instance type in the Capacity Reservation Fleet. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#instance-weight"
         *        >Instance type weight</a> in the <i>Amazon EC2 User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder weight(Double weight);

        /**
         * <p>
         * The priority of the instance type in the Capacity Reservation Fleet. For more information, see <a
         * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#instance-priority">Instance
         * type priority</a> in the <i>Amazon EC2 User Guide</i>.
         * </p>
         * 
         * @param priority
         *        The priority of the instance type in the Capacity Reservation Fleet. For more information, see <a
         *        href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/crfleet-concepts.html#instance-priority">
         *        Instance type priority</a> in the <i>Amazon EC2 User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);
    }

    static final class BuilderImpl implements Builder {
        private String capacityReservationId;

        private String availabilityZoneId;

        private String instanceType;

        private String instancePlatform;

        private String availabilityZone;

        private Integer totalInstanceCount;

        private Double fulfilledCapacity;

        private Boolean ebsOptimized;

        private Instant createDate;

        private Double weight;

        private Integer priority;

        private BuilderImpl() {
        }

        private BuilderImpl(FleetCapacityReservation model) {
            capacityReservationId(model.capacityReservationId);
            availabilityZoneId(model.availabilityZoneId);
            instanceType(model.instanceType);
            instancePlatform(model.instancePlatform);
            availabilityZone(model.availabilityZone);
            totalInstanceCount(model.totalInstanceCount);
            fulfilledCapacity(model.fulfilledCapacity);
            ebsOptimized(model.ebsOptimized);
            createDate(model.createDate);
            weight(model.weight);
            priority(model.priority);
        }

        public final String getCapacityReservationId() {
            return capacityReservationId;
        }

        public final void setCapacityReservationId(String capacityReservationId) {
            this.capacityReservationId = capacityReservationId;
        }

        @Override
        public final Builder capacityReservationId(String capacityReservationId) {
            this.capacityReservationId = capacityReservationId;
            return this;
        }

        public final String getAvailabilityZoneId() {
            return availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final String getInstancePlatform() {
            return instancePlatform;
        }

        public final void setInstancePlatform(String instancePlatform) {
            this.instancePlatform = instancePlatform;
        }

        @Override
        public final Builder instancePlatform(String instancePlatform) {
            this.instancePlatform = instancePlatform;
            return this;
        }

        @Override
        public final Builder instancePlatform(CapacityReservationInstancePlatform instancePlatform) {
            this.instancePlatform(instancePlatform == null ? null : instancePlatform.toString());
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final Integer getTotalInstanceCount() {
            return totalInstanceCount;
        }

        public final void setTotalInstanceCount(Integer totalInstanceCount) {
            this.totalInstanceCount = totalInstanceCount;
        }

        @Override
        public final Builder totalInstanceCount(Integer totalInstanceCount) {
            this.totalInstanceCount = totalInstanceCount;
            return this;
        }

        public final Double getFulfilledCapacity() {
            return fulfilledCapacity;
        }

        public final void setFulfilledCapacity(Double fulfilledCapacity) {
            this.fulfilledCapacity = fulfilledCapacity;
        }

        @Override
        public final Builder fulfilledCapacity(Double fulfilledCapacity) {
            this.fulfilledCapacity = fulfilledCapacity;
            return this;
        }

        public final Boolean getEbsOptimized() {
            return ebsOptimized;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final Instant getCreateDate() {
            return createDate;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final Double getWeight() {
            return weight;
        }

        public final void setWeight(Double weight) {
            this.weight = weight;
        }

        @Override
        public final Builder weight(Double weight) {
            this.weight = weight;
            return this;
        }

        public final Integer getPriority() {
            return priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        @Override
        public FleetCapacityReservation build() {
            return new FleetCapacityReservation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
