/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EndpointIpAddressType {
    IPV4("ipv4"),
    IPV6("ipv6"),
    DUAL_STACK("dual-stack"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EndpointIpAddressType> VALUE_MAP;
    private final String value;

    private EndpointIpAddressType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EndpointIpAddressType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EndpointIpAddressType> knownValues() {
        EnumSet<EndpointIpAddressType> knownValues = EnumSet.allOf(EndpointIpAddressType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EndpointIpAddressType.class, EndpointIpAddressType::toString);
    }
}

