/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the current security configuration of an active VPN tunnel.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ActiveVpnTunnelStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<ActiveVpnTunnelStatus.Builder, ActiveVpnTunnelStatus> {
    private static final SdkField<String> PHASE1_ENCRYPTION_ALGORITHM_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Phase1EncryptionAlgorithm")
            .getter(getter(ActiveVpnTunnelStatus::phase1EncryptionAlgorithm))
            .setter(setter(Builder::phase1EncryptionAlgorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase1EncryptionAlgorithm")
                    .unmarshallLocationName("phase1EncryptionAlgorithm").build()).build();

    private static final SdkField<String> PHASE2_ENCRYPTION_ALGORITHM_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Phase2EncryptionAlgorithm")
            .getter(getter(ActiveVpnTunnelStatus::phase2EncryptionAlgorithm))
            .setter(setter(Builder::phase2EncryptionAlgorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase2EncryptionAlgorithm")
                    .unmarshallLocationName("phase2EncryptionAlgorithm").build()).build();

    private static final SdkField<String> PHASE1_INTEGRITY_ALGORITHM_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Phase1IntegrityAlgorithm")
            .getter(getter(ActiveVpnTunnelStatus::phase1IntegrityAlgorithm))
            .setter(setter(Builder::phase1IntegrityAlgorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase1IntegrityAlgorithm")
                    .unmarshallLocationName("phase1IntegrityAlgorithm").build()).build();

    private static final SdkField<String> PHASE2_INTEGRITY_ALGORITHM_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("Phase2IntegrityAlgorithm")
            .getter(getter(ActiveVpnTunnelStatus::phase2IntegrityAlgorithm))
            .setter(setter(Builder::phase2IntegrityAlgorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase2IntegrityAlgorithm")
                    .unmarshallLocationName("phase2IntegrityAlgorithm").build()).build();

    private static final SdkField<Integer> PHASE1_DH_GROUP_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Phase1DHGroup")
            .getter(getter(ActiveVpnTunnelStatus::phase1DHGroup))
            .setter(setter(Builder::phase1DHGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase1DHGroup")
                    .unmarshallLocationName("phase1DHGroup").build()).build();

    private static final SdkField<Integer> PHASE2_DH_GROUP_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("Phase2DHGroup")
            .getter(getter(ActiveVpnTunnelStatus::phase2DHGroup))
            .setter(setter(Builder::phase2DHGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phase2DHGroup")
                    .unmarshallLocationName("phase2DHGroup").build()).build();

    private static final SdkField<String> IKE_VERSION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("IkeVersion")
            .getter(getter(ActiveVpnTunnelStatus::ikeVersion))
            .setter(setter(Builder::ikeVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IkeVersion")
                    .unmarshallLocationName("ikeVersion").build()).build();

    private static final SdkField<String> PROVISIONING_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ProvisioningStatus")
            .getter(getter(ActiveVpnTunnelStatus::provisioningStatusAsString))
            .setter(setter(Builder::provisioningStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningStatus")
                    .unmarshallLocationName("provisioningStatus").build()).build();

    private static final SdkField<String> PROVISIONING_STATUS_REASON_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ProvisioningStatusReason")
            .getter(getter(ActiveVpnTunnelStatus::provisioningStatusReason))
            .setter(setter(Builder::provisioningStatusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningStatusReason")
                    .unmarshallLocationName("provisioningStatusReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PHASE1_ENCRYPTION_ALGORITHM_FIELD, PHASE2_ENCRYPTION_ALGORITHM_FIELD, PHASE1_INTEGRITY_ALGORITHM_FIELD,
            PHASE2_INTEGRITY_ALGORITHM_FIELD, PHASE1_DH_GROUP_FIELD, PHASE2_DH_GROUP_FIELD, IKE_VERSION_FIELD,
            PROVISIONING_STATUS_FIELD, PROVISIONING_STATUS_REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String phase1EncryptionAlgorithm;

    private final String phase2EncryptionAlgorithm;

    private final String phase1IntegrityAlgorithm;

    private final String phase2IntegrityAlgorithm;

    private final Integer phase1DHGroup;

    private final Integer phase2DHGroup;

    private final String ikeVersion;

    private final String provisioningStatus;

    private final String provisioningStatusReason;

    private ActiveVpnTunnelStatus(BuilderImpl builder) {
        this.phase1EncryptionAlgorithm = builder.phase1EncryptionAlgorithm;
        this.phase2EncryptionAlgorithm = builder.phase2EncryptionAlgorithm;
        this.phase1IntegrityAlgorithm = builder.phase1IntegrityAlgorithm;
        this.phase2IntegrityAlgorithm = builder.phase2IntegrityAlgorithm;
        this.phase1DHGroup = builder.phase1DHGroup;
        this.phase2DHGroup = builder.phase2DHGroup;
        this.ikeVersion = builder.ikeVersion;
        this.provisioningStatus = builder.provisioningStatus;
        this.provisioningStatusReason = builder.provisioningStatusReason;
    }

    /**
     * <p>
     * The encryption algorithm negotiated in Phase 1 IKE negotiations.
     * </p>
     * 
     * @return The encryption algorithm negotiated in Phase 1 IKE negotiations.
     */
    public final String phase1EncryptionAlgorithm() {
        return phase1EncryptionAlgorithm;
    }

    /**
     * <p>
     * The encryption algorithm negotiated in Phase 2 IKE negotiations.
     * </p>
     * 
     * @return The encryption algorithm negotiated in Phase 2 IKE negotiations.
     */
    public final String phase2EncryptionAlgorithm() {
        return phase2EncryptionAlgorithm;
    }

    /**
     * <p>
     * The integrity algorithm negotiated in Phase 1 IKE negotiations.
     * </p>
     * 
     * @return The integrity algorithm negotiated in Phase 1 IKE negotiations.
     */
    public final String phase1IntegrityAlgorithm() {
        return phase1IntegrityAlgorithm;
    }

    /**
     * <p>
     * The integrity algorithm negotiated in Phase 2 IKE negotiations.
     * </p>
     * 
     * @return The integrity algorithm negotiated in Phase 2 IKE negotiations.
     */
    public final String phase2IntegrityAlgorithm() {
        return phase2IntegrityAlgorithm;
    }

    /**
     * <p>
     * The Diffie-Hellman group number being used in Phase 1 IKE negotiations.
     * </p>
     * 
     * @return The Diffie-Hellman group number being used in Phase 1 IKE negotiations.
     */
    public final Integer phase1DHGroup() {
        return phase1DHGroup;
    }

    /**
     * <p>
     * The Diffie-Hellman group number being used in Phase 2 IKE negotiations.
     * </p>
     * 
     * @return The Diffie-Hellman group number being used in Phase 2 IKE negotiations.
     */
    public final Integer phase2DHGroup() {
        return phase2DHGroup;
    }

    /**
     * <p>
     * The version of the Internet Key Exchange (IKE) protocol being used.
     * </p>
     * 
     * @return The version of the Internet Key Exchange (IKE) protocol being used.
     */
    public final String ikeVersion() {
        return ikeVersion;
    }

    /**
     * <p>
     * The current provisioning status of the VPN tunnel.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #provisioningStatus} will return {@link VpnTunnelProvisioningStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #provisioningStatusAsString}.
     * </p>
     * 
     * @return The current provisioning status of the VPN tunnel.
     * @see VpnTunnelProvisioningStatus
     */
    public final VpnTunnelProvisioningStatus provisioningStatus() {
        return VpnTunnelProvisioningStatus.fromValue(provisioningStatus);
    }

    /**
     * <p>
     * The current provisioning status of the VPN tunnel.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #provisioningStatus} will return {@link VpnTunnelProvisioningStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #provisioningStatusAsString}.
     * </p>
     * 
     * @return The current provisioning status of the VPN tunnel.
     * @see VpnTunnelProvisioningStatus
     */
    public final String provisioningStatusAsString() {
        return provisioningStatus;
    }

    /**
     * <p>
     * The reason for the current provisioning status.
     * </p>
     * 
     * @return The reason for the current provisioning status.
     */
    public final String provisioningStatusReason() {
        return provisioningStatusReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(phase1EncryptionAlgorithm());
        hashCode = 31 * hashCode + Objects.hashCode(phase2EncryptionAlgorithm());
        hashCode = 31 * hashCode + Objects.hashCode(phase1IntegrityAlgorithm());
        hashCode = 31 * hashCode + Objects.hashCode(phase2IntegrityAlgorithm());
        hashCode = 31 * hashCode + Objects.hashCode(phase1DHGroup());
        hashCode = 31 * hashCode + Objects.hashCode(phase2DHGroup());
        hashCode = 31 * hashCode + Objects.hashCode(ikeVersion());
        hashCode = 31 * hashCode + Objects.hashCode(provisioningStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(provisioningStatusReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActiveVpnTunnelStatus)) {
            return false;
        }
        ActiveVpnTunnelStatus other = (ActiveVpnTunnelStatus) obj;
        return Objects.equals(phase1EncryptionAlgorithm(), other.phase1EncryptionAlgorithm())
                && Objects.equals(phase2EncryptionAlgorithm(), other.phase2EncryptionAlgorithm())
                && Objects.equals(phase1IntegrityAlgorithm(), other.phase1IntegrityAlgorithm())
                && Objects.equals(phase2IntegrityAlgorithm(), other.phase2IntegrityAlgorithm())
                && Objects.equals(phase1DHGroup(), other.phase1DHGroup())
                && Objects.equals(phase2DHGroup(), other.phase2DHGroup()) && Objects.equals(ikeVersion(), other.ikeVersion())
                && Objects.equals(provisioningStatusAsString(), other.provisioningStatusAsString())
                && Objects.equals(provisioningStatusReason(), other.provisioningStatusReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ActiveVpnTunnelStatus").add("Phase1EncryptionAlgorithm", phase1EncryptionAlgorithm())
                .add("Phase2EncryptionAlgorithm", phase2EncryptionAlgorithm())
                .add("Phase1IntegrityAlgorithm", phase1IntegrityAlgorithm())
                .add("Phase2IntegrityAlgorithm", phase2IntegrityAlgorithm()).add("Phase1DHGroup", phase1DHGroup())
                .add("Phase2DHGroup", phase2DHGroup()).add("IkeVersion", ikeVersion())
                .add("ProvisioningStatus", provisioningStatusAsString())
                .add("ProvisioningStatusReason", provisioningStatusReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Phase1EncryptionAlgorithm":
            return Optional.ofNullable(clazz.cast(phase1EncryptionAlgorithm()));
        case "Phase2EncryptionAlgorithm":
            return Optional.ofNullable(clazz.cast(phase2EncryptionAlgorithm()));
        case "Phase1IntegrityAlgorithm":
            return Optional.ofNullable(clazz.cast(phase1IntegrityAlgorithm()));
        case "Phase2IntegrityAlgorithm":
            return Optional.ofNullable(clazz.cast(phase2IntegrityAlgorithm()));
        case "Phase1DHGroup":
            return Optional.ofNullable(clazz.cast(phase1DHGroup()));
        case "Phase2DHGroup":
            return Optional.ofNullable(clazz.cast(phase2DHGroup()));
        case "IkeVersion":
            return Optional.ofNullable(clazz.cast(ikeVersion()));
        case "ProvisioningStatus":
            return Optional.ofNullable(clazz.cast(provisioningStatusAsString()));
        case "ProvisioningStatusReason":
            return Optional.ofNullable(clazz.cast(provisioningStatusReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Phase1EncryptionAlgorithm", PHASE1_ENCRYPTION_ALGORITHM_FIELD);
        map.put("Phase2EncryptionAlgorithm", PHASE2_ENCRYPTION_ALGORITHM_FIELD);
        map.put("Phase1IntegrityAlgorithm", PHASE1_INTEGRITY_ALGORITHM_FIELD);
        map.put("Phase2IntegrityAlgorithm", PHASE2_INTEGRITY_ALGORITHM_FIELD);
        map.put("Phase1DHGroup", PHASE1_DH_GROUP_FIELD);
        map.put("Phase2DHGroup", PHASE2_DH_GROUP_FIELD);
        map.put("IkeVersion", IKE_VERSION_FIELD);
        map.put("ProvisioningStatus", PROVISIONING_STATUS_FIELD);
        map.put("ProvisioningStatusReason", PROVISIONING_STATUS_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ActiveVpnTunnelStatus, T> g) {
        return obj -> g.apply((ActiveVpnTunnelStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ActiveVpnTunnelStatus> {
        /**
         * <p>
         * The encryption algorithm negotiated in Phase 1 IKE negotiations.
         * </p>
         * 
         * @param phase1EncryptionAlgorithm
         *        The encryption algorithm negotiated in Phase 1 IKE negotiations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phase1EncryptionAlgorithm(String phase1EncryptionAlgorithm);

        /**
         * <p>
         * The encryption algorithm negotiated in Phase 2 IKE negotiations.
         * </p>
         * 
         * @param phase2EncryptionAlgorithm
         *        The encryption algorithm negotiated in Phase 2 IKE negotiations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phase2EncryptionAlgorithm(String phase2EncryptionAlgorithm);

        /**
         * <p>
         * The integrity algorithm negotiated in Phase 1 IKE negotiations.
         * </p>
         * 
         * @param phase1IntegrityAlgorithm
         *        The integrity algorithm negotiated in Phase 1 IKE negotiations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phase1IntegrityAlgorithm(String phase1IntegrityAlgorithm);

        /**
         * <p>
         * The integrity algorithm negotiated in Phase 2 IKE negotiations.
         * </p>
         * 
         * @param phase2IntegrityAlgorithm
         *        The integrity algorithm negotiated in Phase 2 IKE negotiations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phase2IntegrityAlgorithm(String phase2IntegrityAlgorithm);

        /**
         * <p>
         * The Diffie-Hellman group number being used in Phase 1 IKE negotiations.
         * </p>
         * 
         * @param phase1DHGroup
         *        The Diffie-Hellman group number being used in Phase 1 IKE negotiations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phase1DHGroup(Integer phase1DHGroup);

        /**
         * <p>
         * The Diffie-Hellman group number being used in Phase 2 IKE negotiations.
         * </p>
         * 
         * @param phase2DHGroup
         *        The Diffie-Hellman group number being used in Phase 2 IKE negotiations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phase2DHGroup(Integer phase2DHGroup);

        /**
         * <p>
         * The version of the Internet Key Exchange (IKE) protocol being used.
         * </p>
         * 
         * @param ikeVersion
         *        The version of the Internet Key Exchange (IKE) protocol being used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ikeVersion(String ikeVersion);

        /**
         * <p>
         * The current provisioning status of the VPN tunnel.
         * </p>
         * 
         * @param provisioningStatus
         *        The current provisioning status of the VPN tunnel.
         * @see VpnTunnelProvisioningStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpnTunnelProvisioningStatus
         */
        Builder provisioningStatus(String provisioningStatus);

        /**
         * <p>
         * The current provisioning status of the VPN tunnel.
         * </p>
         * 
         * @param provisioningStatus
         *        The current provisioning status of the VPN tunnel.
         * @see VpnTunnelProvisioningStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VpnTunnelProvisioningStatus
         */
        Builder provisioningStatus(VpnTunnelProvisioningStatus provisioningStatus);

        /**
         * <p>
         * The reason for the current provisioning status.
         * </p>
         * 
         * @param provisioningStatusReason
         *        The reason for the current provisioning status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisioningStatusReason(String provisioningStatusReason);
    }

    static final class BuilderImpl implements Builder {
        private String phase1EncryptionAlgorithm;

        private String phase2EncryptionAlgorithm;

        private String phase1IntegrityAlgorithm;

        private String phase2IntegrityAlgorithm;

        private Integer phase1DHGroup;

        private Integer phase2DHGroup;

        private String ikeVersion;

        private String provisioningStatus;

        private String provisioningStatusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(ActiveVpnTunnelStatus model) {
            phase1EncryptionAlgorithm(model.phase1EncryptionAlgorithm);
            phase2EncryptionAlgorithm(model.phase2EncryptionAlgorithm);
            phase1IntegrityAlgorithm(model.phase1IntegrityAlgorithm);
            phase2IntegrityAlgorithm(model.phase2IntegrityAlgorithm);
            phase1DHGroup(model.phase1DHGroup);
            phase2DHGroup(model.phase2DHGroup);
            ikeVersion(model.ikeVersion);
            provisioningStatus(model.provisioningStatus);
            provisioningStatusReason(model.provisioningStatusReason);
        }

        public final String getPhase1EncryptionAlgorithm() {
            return phase1EncryptionAlgorithm;
        }

        public final void setPhase1EncryptionAlgorithm(String phase1EncryptionAlgorithm) {
            this.phase1EncryptionAlgorithm = phase1EncryptionAlgorithm;
        }

        @Override
        public final Builder phase1EncryptionAlgorithm(String phase1EncryptionAlgorithm) {
            this.phase1EncryptionAlgorithm = phase1EncryptionAlgorithm;
            return this;
        }

        public final String getPhase2EncryptionAlgorithm() {
            return phase2EncryptionAlgorithm;
        }

        public final void setPhase2EncryptionAlgorithm(String phase2EncryptionAlgorithm) {
            this.phase2EncryptionAlgorithm = phase2EncryptionAlgorithm;
        }

        @Override
        public final Builder phase2EncryptionAlgorithm(String phase2EncryptionAlgorithm) {
            this.phase2EncryptionAlgorithm = phase2EncryptionAlgorithm;
            return this;
        }

        public final String getPhase1IntegrityAlgorithm() {
            return phase1IntegrityAlgorithm;
        }

        public final void setPhase1IntegrityAlgorithm(String phase1IntegrityAlgorithm) {
            this.phase1IntegrityAlgorithm = phase1IntegrityAlgorithm;
        }

        @Override
        public final Builder phase1IntegrityAlgorithm(String phase1IntegrityAlgorithm) {
            this.phase1IntegrityAlgorithm = phase1IntegrityAlgorithm;
            return this;
        }

        public final String getPhase2IntegrityAlgorithm() {
            return phase2IntegrityAlgorithm;
        }

        public final void setPhase2IntegrityAlgorithm(String phase2IntegrityAlgorithm) {
            this.phase2IntegrityAlgorithm = phase2IntegrityAlgorithm;
        }

        @Override
        public final Builder phase2IntegrityAlgorithm(String phase2IntegrityAlgorithm) {
            this.phase2IntegrityAlgorithm = phase2IntegrityAlgorithm;
            return this;
        }

        public final Integer getPhase1DHGroup() {
            return phase1DHGroup;
        }

        public final void setPhase1DHGroup(Integer phase1DHGroup) {
            this.phase1DHGroup = phase1DHGroup;
        }

        @Override
        public final Builder phase1DHGroup(Integer phase1DHGroup) {
            this.phase1DHGroup = phase1DHGroup;
            return this;
        }

        public final Integer getPhase2DHGroup() {
            return phase2DHGroup;
        }

        public final void setPhase2DHGroup(Integer phase2DHGroup) {
            this.phase2DHGroup = phase2DHGroup;
        }

        @Override
        public final Builder phase2DHGroup(Integer phase2DHGroup) {
            this.phase2DHGroup = phase2DHGroup;
            return this;
        }

        public final String getIkeVersion() {
            return ikeVersion;
        }

        public final void setIkeVersion(String ikeVersion) {
            this.ikeVersion = ikeVersion;
        }

        @Override
        public final Builder ikeVersion(String ikeVersion) {
            this.ikeVersion = ikeVersion;
            return this;
        }

        public final String getProvisioningStatus() {
            return provisioningStatus;
        }

        public final void setProvisioningStatus(String provisioningStatus) {
            this.provisioningStatus = provisioningStatus;
        }

        @Override
        public final Builder provisioningStatus(String provisioningStatus) {
            this.provisioningStatus = provisioningStatus;
            return this;
        }

        @Override
        public final Builder provisioningStatus(VpnTunnelProvisioningStatus provisioningStatus) {
            this.provisioningStatus(provisioningStatus == null ? null : provisioningStatus.toString());
            return this;
        }

        public final String getProvisioningStatusReason() {
            return provisioningStatusReason;
        }

        public final void setProvisioningStatusReason(String provisioningStatusReason) {
            this.provisioningStatusReason = provisioningStatusReason;
        }

        @Override
        public final Builder provisioningStatusReason(String provisioningStatusReason) {
            this.provisioningStatusReason = provisioningStatusReason;
            return this;
        }

        @Override
        public ActiveVpnTunnelStatus build() {
            return new ActiveVpnTunnelStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
