/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.MacModificationTask;
import software.amazon.awssdk.services.ec2.model.MacModificationTaskListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeMacModificationTasksResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeMacModificationTasksResponse> {
    private static final SdkField<List<MacModificationTask>> MAC_MODIFICATION_TASKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MacModificationTasks").getter(DescribeMacModificationTasksResponse.getter(DescribeMacModificationTasksResponse::macModificationTasks)).setter(DescribeMacModificationTasksResponse.setter(Builder::macModificationTasks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MacModificationTaskSet").unmarshallLocationName("macModificationTaskSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MacModificationTask::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeMacModificationTasksResponse.getter(DescribeMacModificationTasksResponse::nextToken)).setter(DescribeMacModificationTasksResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAC_MODIFICATION_TASKS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeMacModificationTasksResponse.memberNameToFieldInitializer();
    private final List<MacModificationTask> macModificationTasks;
    private final String nextToken;

    private DescribeMacModificationTasksResponse(BuilderImpl builder) {
        super(builder);
        this.macModificationTasks = builder.macModificationTasks;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasMacModificationTasks() {
        return this.macModificationTasks != null && !(this.macModificationTasks instanceof SdkAutoConstructList);
    }

    public final List<MacModificationTask> macModificationTasks() {
        return this.macModificationTasks;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMacModificationTasks() ? this.macModificationTasks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMacModificationTasksResponse)) {
            return false;
        }
        DescribeMacModificationTasksResponse other = (DescribeMacModificationTasksResponse)((Object)obj);
        return this.hasMacModificationTasks() == other.hasMacModificationTasks() && Objects.equals(this.macModificationTasks(), other.macModificationTasks()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeMacModificationTasksResponse").add("MacModificationTasks", this.hasMacModificationTasks() ? this.macModificationTasks() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MacModificationTasks": {
                return Optional.ofNullable(clazz.cast(this.macModificationTasks()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MacModificationTaskSet", MAC_MODIFICATION_TASKS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeMacModificationTasksResponse, T> g) {
        return obj -> g.apply((DescribeMacModificationTasksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<MacModificationTask> macModificationTasks = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMacModificationTasksResponse model) {
            super(model);
            this.macModificationTasks(model.macModificationTasks);
            this.nextToken(model.nextToken);
        }

        public final List<MacModificationTask.Builder> getMacModificationTasks() {
            List<MacModificationTask.Builder> result = MacModificationTaskListCopier.copyToBuilder(this.macModificationTasks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMacModificationTasks(Collection<MacModificationTask.BuilderImpl> macModificationTasks) {
            this.macModificationTasks = MacModificationTaskListCopier.copyFromBuilder(macModificationTasks);
        }

        @Override
        public final Builder macModificationTasks(Collection<MacModificationTask> macModificationTasks) {
            this.macModificationTasks = MacModificationTaskListCopier.copy(macModificationTasks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder macModificationTasks(MacModificationTask ... macModificationTasks) {
            this.macModificationTasks(Arrays.asList(macModificationTasks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder macModificationTasks(Consumer<MacModificationTask.Builder> ... macModificationTasks) {
            this.macModificationTasks(Stream.of(macModificationTasks).map(c -> (MacModificationTask)((MacModificationTask.Builder)MacModificationTask.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeMacModificationTasksResponse build() {
            return new DescribeMacModificationTasksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeMacModificationTasksResponse> {
        public Builder macModificationTasks(Collection<MacModificationTask> var1);

        public Builder macModificationTasks(MacModificationTask ... var1);

        public Builder macModificationTasks(Consumer<MacModificationTask.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

