/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.AddedPrincipal;
import software.amazon.awssdk.services.ec2.model.AddedPrincipalSetCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyVpcEndpointServicePermissionsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, ModifyVpcEndpointServicePermissionsResponse> {
    private static final SdkField<List<AddedPrincipal>> ADDED_PRINCIPALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AddedPrincipals").getter(ModifyVpcEndpointServicePermissionsResponse.getter(ModifyVpcEndpointServicePermissionsResponse::addedPrincipals)).setter(ModifyVpcEndpointServicePermissionsResponse.setter(Builder::addedPrincipals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddedPrincipalSet").unmarshallLocationName("addedPrincipalSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AddedPrincipal::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<Boolean> RETURN_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ReturnValue").getter(ModifyVpcEndpointServicePermissionsResponse.getter(ModifyVpcEndpointServicePermissionsResponse::returnValue)).setter(ModifyVpcEndpointServicePermissionsResponse.setter(Builder::returnValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Return").unmarshallLocationName("return").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDED_PRINCIPALS_FIELD, RETURN_VALUE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModifyVpcEndpointServicePermissionsResponse.memberNameToFieldInitializer();
    private final List<AddedPrincipal> addedPrincipals;
    private final Boolean returnValue;

    private ModifyVpcEndpointServicePermissionsResponse(BuilderImpl builder) {
        super(builder);
        this.addedPrincipals = builder.addedPrincipals;
        this.returnValue = builder.returnValue;
    }

    public final boolean hasAddedPrincipals() {
        return this.addedPrincipals != null && !(this.addedPrincipals instanceof SdkAutoConstructList);
    }

    public final List<AddedPrincipal> addedPrincipals() {
        return this.addedPrincipals;
    }

    public final Boolean returnValue() {
        return this.returnValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAddedPrincipals() ? this.addedPrincipals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.returnValue());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVpcEndpointServicePermissionsResponse)) {
            return false;
        }
        ModifyVpcEndpointServicePermissionsResponse other = (ModifyVpcEndpointServicePermissionsResponse)((Object)obj);
        return this.hasAddedPrincipals() == other.hasAddedPrincipals() && Objects.equals(this.addedPrincipals(), other.addedPrincipals()) && Objects.equals(this.returnValue(), other.returnValue());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyVpcEndpointServicePermissionsResponse").add("AddedPrincipals", this.hasAddedPrincipals() ? this.addedPrincipals() : null).add("ReturnValue", (Object)this.returnValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AddedPrincipals": {
                return Optional.ofNullable(clazz.cast(this.addedPrincipals()));
            }
            case "ReturnValue": {
                return Optional.ofNullable(clazz.cast(this.returnValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AddedPrincipalSet", ADDED_PRINCIPALS_FIELD);
        map.put("Return", RETURN_VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyVpcEndpointServicePermissionsResponse, T> g) {
        return obj -> g.apply((ModifyVpcEndpointServicePermissionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<AddedPrincipal> addedPrincipals = DefaultSdkAutoConstructList.getInstance();
        private Boolean returnValue;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVpcEndpointServicePermissionsResponse model) {
            super(model);
            this.addedPrincipals(model.addedPrincipals);
            this.returnValue(model.returnValue);
        }

        public final List<AddedPrincipal.Builder> getAddedPrincipals() {
            List<AddedPrincipal.Builder> result = AddedPrincipalSetCopier.copyToBuilder(this.addedPrincipals);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAddedPrincipals(Collection<AddedPrincipal.BuilderImpl> addedPrincipals) {
            this.addedPrincipals = AddedPrincipalSetCopier.copyFromBuilder(addedPrincipals);
        }

        @Override
        public final Builder addedPrincipals(Collection<AddedPrincipal> addedPrincipals) {
            this.addedPrincipals = AddedPrincipalSetCopier.copy(addedPrincipals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addedPrincipals(AddedPrincipal ... addedPrincipals) {
            this.addedPrincipals(Arrays.asList(addedPrincipals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addedPrincipals(Consumer<AddedPrincipal.Builder> ... addedPrincipals) {
            this.addedPrincipals(Stream.of(addedPrincipals).map(c -> (AddedPrincipal)((AddedPrincipal.Builder)AddedPrincipal.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getReturnValue() {
            return this.returnValue;
        }

        public final void setReturnValue(Boolean returnValue) {
            this.returnValue = returnValue;
        }

        @Override
        public final Builder returnValue(Boolean returnValue) {
            this.returnValue = returnValue;
            return this;
        }

        @Override
        public ModifyVpcEndpointServicePermissionsResponse build() {
            return new ModifyVpcEndpointServicePermissionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyVpcEndpointServicePermissionsResponse> {
        public Builder addedPrincipals(Collection<AddedPrincipal> var1);

        public Builder addedPrincipals(AddedPrincipal ... var1);

        public Builder addedPrincipals(Consumer<AddedPrincipal.Builder> ... var1);

        public Builder returnValue(Boolean var1);
    }
}

