/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeMacModificationTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeMacModificationTasksResponse;
import software.amazon.awssdk.services.ec2.model.MacModificationTask;

public class DescribeMacModificationTasksIterable
implements SdkIterable<DescribeMacModificationTasksResponse> {
    private final Ec2Client client;
    private final DescribeMacModificationTasksRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeMacModificationTasksIterable(Ec2Client client, DescribeMacModificationTasksRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeMacModificationTasksResponseFetcher();
    }

    public Iterator<DescribeMacModificationTasksResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MacModificationTask> macModificationTasks() {
        Function<DescribeMacModificationTasksResponse, Iterator> getIterator = response -> {
            if (response != null && response.macModificationTasks() != null) {
                return response.macModificationTasks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeMacModificationTasksResponseFetcher
    implements SyncPageFetcher<DescribeMacModificationTasksResponse> {
        private DescribeMacModificationTasksResponseFetcher() {
        }

        public boolean hasNextPage(DescribeMacModificationTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeMacModificationTasksResponse nextPage(DescribeMacModificationTasksResponse previousPage) {
            if (previousPage == null) {
                return DescribeMacModificationTasksIterable.this.client.describeMacModificationTasks(DescribeMacModificationTasksIterable.this.firstRequest);
            }
            return DescribeMacModificationTasksIterable.this.client.describeMacModificationTasks((DescribeMacModificationTasksRequest)((Object)DescribeMacModificationTasksIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

