/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.SecurityGroupReference;
import software.amazon.awssdk.services.ec2.model.SecurityGroupReferencesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSecurityGroupReferencesResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeSecurityGroupReferencesResponse> {
    private static final SdkField<List<SecurityGroupReference>> SECURITY_GROUP_REFERENCE_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupReferenceSet").getter(DescribeSecurityGroupReferencesResponse.getter(DescribeSecurityGroupReferencesResponse::securityGroupReferenceSet)).setter(DescribeSecurityGroupReferencesResponse.setter(Builder::securityGroupReferenceSet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupReferenceSet").unmarshallLocationName("securityGroupReferenceSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SecurityGroupReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_GROUP_REFERENCE_SET_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeSecurityGroupReferencesResponse.memberNameToFieldInitializer();
    private final List<SecurityGroupReference> securityGroupReferenceSet;

    private DescribeSecurityGroupReferencesResponse(BuilderImpl builder) {
        super(builder);
        this.securityGroupReferenceSet = builder.securityGroupReferenceSet;
    }

    public final boolean hasSecurityGroupReferenceSet() {
        return this.securityGroupReferenceSet != null && !(this.securityGroupReferenceSet instanceof SdkAutoConstructList);
    }

    public final List<SecurityGroupReference> securityGroupReferenceSet() {
        return this.securityGroupReferenceSet;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupReferenceSet() ? this.securityGroupReferenceSet() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSecurityGroupReferencesResponse)) {
            return false;
        }
        DescribeSecurityGroupReferencesResponse other = (DescribeSecurityGroupReferencesResponse)((Object)obj);
        return this.hasSecurityGroupReferenceSet() == other.hasSecurityGroupReferenceSet() && Objects.equals(this.securityGroupReferenceSet(), other.securityGroupReferenceSet());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeSecurityGroupReferencesResponse").add("SecurityGroupReferenceSet", this.hasSecurityGroupReferenceSet() ? this.securityGroupReferenceSet() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SecurityGroupReferenceSet": {
                return Optional.ofNullable(clazz.cast(this.securityGroupReferenceSet()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<SecurityGroupReference>>> map = new HashMap<String, SdkField<List<SecurityGroupReference>>>();
        map.put("SecurityGroupReferenceSet", SECURITY_GROUP_REFERENCE_SET_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeSecurityGroupReferencesResponse, T> g) {
        return obj -> g.apply((DescribeSecurityGroupReferencesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<SecurityGroupReference> securityGroupReferenceSet = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSecurityGroupReferencesResponse model) {
            super(model);
            this.securityGroupReferenceSet(model.securityGroupReferenceSet);
        }

        public final List<SecurityGroupReference.Builder> getSecurityGroupReferenceSet() {
            List<SecurityGroupReference.Builder> result = SecurityGroupReferencesCopier.copyToBuilder(this.securityGroupReferenceSet);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecurityGroupReferenceSet(Collection<SecurityGroupReference.BuilderImpl> securityGroupReferenceSet) {
            this.securityGroupReferenceSet = SecurityGroupReferencesCopier.copyFromBuilder(securityGroupReferenceSet);
        }

        @Override
        public final Builder securityGroupReferenceSet(Collection<SecurityGroupReference> securityGroupReferenceSet) {
            this.securityGroupReferenceSet = SecurityGroupReferencesCopier.copy(securityGroupReferenceSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupReferenceSet(SecurityGroupReference ... securityGroupReferenceSet) {
            this.securityGroupReferenceSet(Arrays.asList(securityGroupReferenceSet));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupReferenceSet(Consumer<SecurityGroupReference.Builder> ... securityGroupReferenceSet) {
            this.securityGroupReferenceSet(Stream.of(securityGroupReferenceSet).map(c -> (SecurityGroupReference)((SecurityGroupReference.Builder)SecurityGroupReference.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeSecurityGroupReferencesResponse build() {
            return new DescribeSecurityGroupReferencesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeSecurityGroupReferencesResponse> {
        public Builder securityGroupReferenceSet(Collection<SecurityGroupReference> var1);

        public Builder securityGroupReferenceSet(SecurityGroupReference ... var1);

        public Builder securityGroupReferenceSet(Consumer<SecurityGroupReference.Builder> ... var1);
    }
}

